
with Libsens.Common;                    use Libsens.Common;
with Libsens.Virtual;                   use Libsens.Virtual;
with Libsens.Virtual.Plugins;           use Libsens.Virtual.Plugins;

package Libsens.Virtual.Step_Sequencer is
   
   type Voice_Type is tagged
      record
	 Id      : Positive := 1;
	 Key     : Key_Type := 36;
	 Sens    : Sens_Type := 95;
	 Length  : Length_Type := 2;
	 Bar     : Positive := 1;
	 Number  : Time_Number_Type := 1;
	 Step    : Time_Unit_Type := 1;
	 Played  : Boolean := False;
	 Note    : String_Access := new String ' ("");
	 Octave  : Octave_num := 0;
	 In_Loop : Boolean := False;
      end record;
   
   type Step_Array_Type is array (Positive range <>) of Voice_Type;
   
   
   type Step_Seq_Plugin_Record is
     new Plugin_Class(Step_seq) with
      record
	 Sequencer : Step_Array_Type(1..128);
	 Bars_Max  : Positive := 8;
      end record;
   
   procedure Print (Filename : in String; Plug : in Step_Seq_Plugin_record);
   
end Libsens.Virtual.Step_Sequencer;
