with Libsens.Common;                    use Libsens.Common;
with Libsens.Virtual;                   use Libsens.Virtual;
with Libsens.MIDI.Messages;             use Libsens.MIDI.Messages;
with Libsens.Virtual.Plugins;           use Libsens.Virtual.Plugins;
package Libsens.Virtual.Prgm_Change is
   
   type Prgm_Change_Type is
      record
	 MSB_Select   : Value_Type := 0;
	 LSB_Select   : Value_Type := 0;
	 Prgm_Num     : Program_Type := 0;
	 
	 
	 Id      : Positive := 1;
	 Bar     : Positive := 1;
	 Number  : Time_Number_Type := 1;
	 Step    : Time_Unit_Type := 1;
	 Played  : Boolean := False;
	 Note    : String_Access := new String ' ("");
	 In_Loop : Boolean := False;	 
      end record;
   
   
   type PC_Array is array (Positive range <>) of Prgm_Change_Type;
   
   
   type Prgm_Change_Plugin_Record is
     new Plugin_Class(PC_List) with
      record
	 Sequencer : Pc_Array(1..128);
	 Bars_Max  : Positive := 128;	 	 
      end record;
   procedure Print (Filename : in String; Plug : in Prgm_Change_Plugin_Record);
end Libsens.Virtual.Prgm_Change;
