
with Text_Io;                           use Text_Io;

package body Libsens.Virtual.Plugins is         
   
   procedure Initialize (Plug      : in out Plugin_Class;
			 Id        : in Plugin_Num;
			 Device    : in Device_Num;
			 Ch        : in Channel_Num;
			 Form      : in Form_Index_Type;
			 Cat       : in Category_Index_Type) is
   begin
      Plug.Id := Id;
      Plug.Device_Id := Device;
      Plug.Ch_Id := Ch;
      Plug.Form_Id := Form;
      Plug.Cat_Id := Cat;
   end Initialize;
   
   procedure Set_Id(Plug       : in out Plugin_Class;
		    Id        : in Plugin_Num) is
   begin
      Plug.Id := Id;
   end Set_Id;
   
   function Get_Id(Plug        : in Plugin_Class) return Plugin_Num is
   begin
      return Plug.Id;
   end Get_Id;
   
   procedure Set_Device(Plug       : in out Plugin_Class;
			Device    : in Device_Num) is
   begin
      Plug.Device_Id := Device;
   end Set_Device;
   
   function Get_Device(Plug        : in Plugin_Class) return Device_Num is
   begin
      return Plug.Device_Id;
   end Get_Device;
   
   procedure Set_Channel(Plug       : in out Plugin_Class;
			 Ch        : in Channel_Num) is
   begin
      Plug.Ch_Id := Ch;
   end Set_Channel;
   
   function Get_Channel(Plug        : in Plugin_Class) return Channel_Num is
   begin
      return Plug.Ch_Id;
   end Get_Channel;
   
   procedure Set_Form(Plug       : in out Plugin_Class;
		      Form      : in Form_Index_Type) is
   begin
      Plug.Form_Id := Form;
   end Set_Form;
   
   function Get_Form(Plug        : in Plugin_Class) return Form_Index_Type is
   begin
      return Plug.Form_Id;
   end Get_Form;
   
   procedure Set_Category(Plug       : in out Plugin_Class;
			  Cat       : in Category_Index_Type) is
   begin
      Plug.Cat_Id := Cat;
   end Set_Category;
   
   function Get_Category(Plug        : in Plugin_Class) return Category_Index_Type is
   begin
      return Plug.Cat_Id;
   end Get_Category;         
   
   
   procedure Print(Filename : in String; Plug : in Plugin_Class) is
      File : File_Type;
   begin
      Open(File, Append_File, Filename);
      Put_Line(File, Plugin_Enum'Image(Plug.Class));      
      Put_Line(File, Boolean'Image(Plug.Printed));
      Put_Line(File, Boolean'Image(Plug.Mutted));	       
      Put_Line(File, Form_Index_Type'Image(Plug.Form_Id));            
      Put_Line(File, Category_Index_Type'Image(Plug.Cat_Id));
      Put_Line(File, Channel_Num'Image(Plug.Ch_Id));      
      Put_Line(File, Device_Num'Image(Plug.Device_Id));
      Put_Line(File, Plug.Name.all);
      Close(File);
   end Print;
end Libsens.Virtual.Plugins;
