with Libsens.Common;                    use Libsens.Common;
with Libsens.Virtual;                   use Libsens.Virtual;
with Libsens.MIDI.Messages;             use Libsens.MIDI.Messages;
with Libsens.Virtual.Plugins;           use Libsens.Virtual.Plugins;
package Libsens.Virtual.CC_Change is
   
   type Ctrl_Change_Type is
      record
	 Ctrl_Name : access String := new String ' ("");
	 Ctrl_Num : Value_Type := 1;
	 Ctrl_Val : Value_Type := 1;
	 
	 Id      : Positive := 1;
	 Bar     : Positive := 1;
	 Number  : Time_Number_Type := 1;
	 Step    : Time_Unit_Type := 1;
	 Played  : Boolean := False;
	 Note    : String_Access := new String ' ("");
	 In_Loop : Boolean := False;	 
      end record;
        
   type Cc_Array is array (Positive range <>) of Ctrl_Change_Type;
   
   
   type CC_Change_Plugin_Record is
     new Plugin_Class(CC_List) with
      record
	 Sequencer : Cc_Array(1..128);
	 Bars_Max  : Positive := 128;
      end record;
   procedure Print (Filename : in String; Plug : in CC_Change_Plugin_Record);
end Libsens.Virtual.CC_Change;
