
with Libsens.MIDI.Instruments;          use Libsens.MIDI.Instruments;
with Libsens.Virtual;                   use Libsens.Virtual;
with Libsens.Virtual.Work_Class;        use Libsens.Virtual.Work_Class;
with Libsens.Processing.Common;         use Libsens.Processing.Common;
with Libsens.Processing.Plugins;        use Libsens.Processing.Plugins;

package Libsens.Processing.Work_Processing is
   
   
   type Plugin_Processing_Access is access all Plugin_Processing'Class;
   
   
   function Initialize(Class : in Plugin_Enum;
		       Plugin : in Abstract_Plugin_Access) return Plugin_Processing_Access;
   
   
   type Process_Array is array (Plugin_Num'Range) of Plugin_Processing_Access;
   
   type Work_Processing_Record;
   
   task type Work_Process(Processing : access Work_Processing_Record) is
      entry Initialize;
      entry Start;
      entry Stop;
      entry Mod_Rec(Status : in Boolean);
      entry Mod_Play(Status : in Boolean);
      entry Mod_Reset;
      entry End_Of_Process;
      entry Halt;
   end Work_Process;
   
   
   
   type Work_Processing_Record is tagged limited
      record
	 Work         : Work_Access;
	 Box          : aliased Messages_box;
	 Process      : Work_Process(Work_Processing_Record'Access);
	 Processes    : Process_Array;	 
	 Instruments  : access Bandmaster_Record;
      end record;
   
   procedure Initialize(Processing : in out Work_Processing_Record;
			Work       : in Work_Access;
			Insts      : access Bandmaster_record);   
            
end Libsens.Processing.Work_Processing;
