
with Ada.Containers.Vectors;            use Ada.Containers;

with Text_Io;                           use Text_Io;
package body Libsens.Processing.Common is
   
   package Printed_Message_Vectors is new Ada.Containers.Vectors(Printed_Message_Index_Type,
								 Printed_Message_Access,
								 "=");         
   
   subtype Messages_Vector_Type is Printed_Message_Vectors.Vector;
   
   use Printed_Message_Vectors;
   
   task body Messages_Box is
      Box : Messages_Vector_Type;
      Full : Boolean := False;
      Empty_Message : constant Printed_Message_Access := null;
   begin
      loop
	 select
	    accept Receive(Message : in Printed_Message_Access) do
	       Box := Box & Message;
	       Full := True;
	    end Receive;
	 or
	    when Full =>
	       accept Send(Message : out Printed_Message_Access) do
		  if Last_Index(Box) /= 0 then
		     Message := First_Element(Box);
		     Delete(Box, 1);
		     if Length(Box) = 0 then
			Full := False;
		     end if;
		  end if;
	       end Send;
	 or
	    when not Full =>	       
	       accept Send(Message : out Printed_Message_Access) do
	 	  Message := Empty_Message;	       
	       end Send;
	 or
	    accept Halt do
	       Put_Line("Messages boxe halted");
	    end Halt;
	    exit;
	 end select;
      end loop;
      
   end Messages_Box;
   
   
end Libsens.Processing.Common;
