-- Author      : Manuel De Girardi
-- Date        : 2010/12/9
-- Version     : 0.0.0pre-alpha_010
-- Description : artificial neural network generator for MidiSurf
-------------------------------------------------------------------------------


with Libsens.Rem_Common;                use Libsens.Rem_Common;

with PragmARC.REM_NN_Wrapper;
use PragmARC.REM_NN_Wrapper;

with PragmARC.Math.Functions;

with Text_Io;                           use Text_Io;

package Libsens.Neural_chord is
   Arg_Error : exception;
   Data_File : File_Type;
   The_Line : String(1..80) := (others => Character'Val(32));
   The_Index, Last : Natural := 0;
   Position : Positive := 1;
   Buffer : array (1..T_Register'length/7) of integer := (others => 0);
   Buffer_Length : Natural := 0;
   First, Register : T_register := (others => 0.0);
   The_Bbyte : T_bbyte := (others => False);
   Reg_File : Register_Io.File_Type;
   package Real_Io is new Text_Io.Float_Io(Real);
   package Real_Math is new PragmARC.Math.Functions (Supplied_Real => Real);
   Data_Length : Natural := 0;
   New_Weigth : Boolean := False;
   --Converged  : real := 0.0075;
end Libsens.Neural_Chord;
