

with Libsens.Virtual;                   use Libsens.Virtual;

with libsens.Neural_Generator;

with PragmARC.REM_NN_Wrapper;
use PragmARC.REM_NN_Wrapper;

with Gnat.Semaphores;
use Gnat.Semaphores;


with Ada.Unchecked_Deallocation;

generic
      Filename     : String;
      Width        : Positive;
      Hidden_Num   : Natural;
      Samples_Max  : Positive;
package Libsens.Monophonic_Generator is
      
      
      
   procedure Initialize (Reuse : in Boolean; Converged : in Float; Max_Epochs : in Positive);
   function Respond(Problem  : in Node_Set) return Node_Set;
   
   package Generator is new Libsens.Neural_Generator(Width, Hidden_Num, Samples_Max);
   use Generator, Generator.Network;
   Samples : Samples_Type(1..Samples_Max) := (others => (others => 0.0));
   
   Monophonic_Lock : Binary_Semaphore(True, Default_Ceiling);
   
   
   ---------------------------------------------
   --   Conversion Node_set to/from note(s).  --
   ---------------------------------------------
   package Neural2chord is
      
      type Note_Type is
	 record
	    Key : Key_Type := 63;
	    Sens : Sens_Type := 64;
	    Length : Length_Type := 8;
	 end record;
	          
      type Notes_Set_Type is array (Positive range <>) of Note_Type;
      
      type Notes_Set_Access is access Notes_Set_Type;
      
      function To_Chord(From : in Node_Set) return Notes_Set_Access;
      
      procedure Free is new Ada.Unchecked_Deallocation(Notes_Set_Type, Notes_Set_Access);
      
   end Neural2chord;
   
   ----------------------------------------------------------
   -- End conversion MONO 
   ----------------------------------------------------------      

   use Neural2chord;
   
end Libsens.Monophonic_Generator;
   
