
with Ada.Calendar;                      use Ada.Calendar;
with Libsens.Common;                    use Libsens.Common;
with Libsens.MIDI.Drivers;              use Libsens.MIDI.Drivers;

package Libsens.MIDI.Instruments is
   
   
   type MIDI_Instrument_Record;
   
   task type Tempo_Sync_Type(Instrument : access Device_Driver_Record'class) is      
      entry Start(Start_Time : in Time; Tempo : in Tempo_Type; Signature : in Time_Signature_type);	 
      entry Stop;
      entry Halt;
   end Tempo_Sync_Type;	       

   --                                                --
   ----------------------------------------------------
   
   ----------------------------------------------------
   -- Modulation sequencer :                         --   
   
   task type Mod_Sequencer_Type(Instrument : access Device_Driver_Record'class) is      
      entry Start(Tempo : in Tempo_Type; Signature : in Time_Signature_type);
      entry Stop;
      entry Rec(In_Rec : in Boolean);
      entry Play(In_Play : in Boolean);
      entry Reset;
      entry Halt;
   end Mod_Sequencer_Type;
   
   
   type MIDI_Instrument_Record is new Device_Driver_Record with
      record
	 
	 Tempo_Sync : Tempo_Sync_Type(MIDI_Instrument_Record'Access);
	 Mod_Seq    : Mod_Sequencer_Type(MIDI_Instrument_Record'Access);
	 
	 Printed        : Boolean := True;
	 Mutted         : Boolean := False;
	 Have_Drums_Kit : Boolean := False;
      end record;
   
   type MIDI_Instrument_Access is access all MIDI_Instrument_Record'Class;
   
   type Instrument_Id is new Positive range 1..128;
   
   type Orchester_Array is array (Instrument_Id range <>) of MIDI_Instrument_Access;
   
   type Bandmaster_Record(Device_Max : Instrument_Id) is tagged
      record
	 Orchester : Orchester_Array(1..Device_Max);
	 Inst_Last      : natural := 0;
      end record;
   
   procedure Initialize(Master : in out Bandmaster_Record; Ignore : in boolean);
      
end Libsens.MIDI.Instruments;
