-- Mal is Musicale architecture library
-- Copyright (C) 2014 Manuel De Girardi

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--

----------------------------------------
--    Musical Architecture Library.   --
----------------------------------------

----------------------------------------
-- Common specifications for Mal :    --


with Ada.Containers.Vectors;
with Interfaces.C;
package Libsens.Mal is
         
   
   use Interfaces;
   package Step_Vectors is new Ada.Containers.Vectors(Positive,
						       C.long,
						       C."=");
   
   package Seq_Vectors is new Ada.Containers.Vectors(Positive,
						     Step_Vectors.Vector,
						     Step_Vectors."=");
   
      
   
end Libsens.Mal;
