
with Libsens.MIDI.Messages;             use Libsens.MIDI.Messages;
with Libsens.Mal;                    use Libsens.Mal;
package Libsens.Data is
   
   type Word16_Type is mod 2**16;
      -- Definit un type de 16 bits.
      -- Est utilisé pour construire des phrases.
      -- Un bit à 1 signifit que la note sera jouer, 0 si non.
      
      type Word16_Index_Type is mod 16;
      -- Définit un index permettant d'adresser un bit dans un Word16_Type;
      
      type Note_Word16_Type is
	 record
	    key : Value_Type := 36;
	    sens : Value_Type := 100;
	    Length : Value_Type := 0;
	    Sentence  : Word16_Type := 0;
	 end record;
      -- Définit une phrase de 16 pas pour une note avec une vélocité et une durée de note.
      
      
      Null_Note : constant Note_Word16_Type := (36,100, 0, 0);
      -- La phrase par defaut dans les tableaux de phrases.
      
      
      type Sentence_Type is array (Value_Type range <>) of Note_Word16_Type;
      -- Un tableau de phrases.
      
      function Beat(Word16 : in Word16_Type; Index : in Natural) return Boolean;
      -- Renvoie Vrai si le bit correspondant à l'"index" à pour valeur 1.
      -- La position dans le mot est calculé modulo 16.
      
      
      procedure Pattern(From : in Sentence_Type; Channel : in Channel_Type; Seq : in out  Seq_Vectors.vector);
      
end Libsens.Data;
