
package body Libsens.Common is
   function image(Signature : in Time_Signature_Type) return String is
      
   begin      
      
      return 
	Positive'Image(Signature.Number) & '/' &
	Positive'Image(signature.Unit);
   end Image;      
   
   
   function Image(Bar_Beat : in Bar_Beat_Type) return String is
      
   begin
      
      return Positive'Image(Bar_Beat.Bar) & '.' &
	Positive'Image(Bar_Beat.Time_Number) & '.' &
	Positive'Image(Bar_Beat.Time_unit);
   end Image;
   
   procedure Next(Bar_Beat    : in out Bar_Beat_Type;
		  Bar         : in Natural;
		  Number      : in Time_Number_Type;
		  Unit        : in Time_Unit_Type) is
      
   begin
      
      if Bar_Beat.Time_Unit + 1 > Unit then
	 Bar_Beat.Time_Unit := 1;
	 if Bar_Beat.Time_Number + 1 > Number then
	    Bar_Beat.Time_Number := 1;
	    if Bar_Beat.Bar < Bar then
	       Bar_Beat.Bar := Bar_Beat.Bar + 1;
	    else
	       Bar_Beat.Bar := 1;
	    end if;
	 else
	    Bar_Beat.Time_Number := Bar_Beat.Time_Number + 1;
	 end if;
      else
	 Bar_Beat.Time_Unit := Bar_Beat.Time_Unit + 1;
      end if;      
   end Next;
   
   function Bpm_To_Duration(Bpm : Tempo_Type;
                            figure : T_figure) return Duration is
   begin
      case figure is
         when Quadruple =>
            return duration(duration(60000.0/Bpm)/16.0)/1000.0;
         when Triple =>
            return duration(duration(60000.0/Bpm)/8.0)/1000.0;
         when Double =>
            return duration(duration(60000.0/Bpm)/4.0)/1000.0;
         when Simple =>
            return duration(duration(60000.0/Bpm)/2.0)/1000.0;
         when Noire =>
            return  duration(60000.0/Bpm)/1000.0;
         When Blanche =>
            return Duration(duration(60000.0/Bpm)*2.0)/1000.0;
         when Ronde =>
            return Duration(duration(60000.0/Bpm)*4.0)/1000.0;
      end case;
   end Bpm_To_Duration;

   function To_Figure(Value : in Value_Type) return T_Figure Is
   begin
      case Value is
         when 0..18 =>
            return Quadruple;
         when 19..36 =>
            return Triple;
         when 37..54 =>
            return Double;
         when 55..72 =>
            return Simple;
         when 73..91 =>
            return Noire;
         when 92..107 =>
            return Blanche;
         when 108..127 =>
            return Ronde;
      end case;
   end To_Figure;
end Libsens.Common;
