-- Skywalker is another attempt of A. i. written with Ada.
-- Skywalker is Copyright (C) 2024 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2024-11-12 09:20:39"
-- Version := "0.0.8r"

with Ada;
with Sky.Versions.Version_Io;
use Sky.Versions.Version_Io;

package body Sky.Project is
   
      procedure Lib_Add(Project : in out Project_Record; Lib : in String) is
   begin

      Project.Libs(Project.Lib_Last + 1).Unit_Name := new String ' (Lib);
      Project.Lib_Last := Project.Lib_Last + 1;

   end Lib_Add;
   
   
   procedure Open(Project : in out Project_Record; Date : Time := Clock) is
   begin
      Project.End_Date := Date;
   end Open;
   procedure Close(Project : in out Project_Record; Date : Time := Clock) is
   begin
      Project.Elapsed := Project.Elapsed + (Date - Project.End_Date);
   end Close;
   
   
   procedure Read (Project : out Project_Access; Project_Name : in String) is
      
      
      Project_Files : File_Type;
      
   begin
      
      

      
      Project := new Project_Record(256);
      
      
      
      
      Open(Project_Files, In_File, Project_Name & "/Versions.lst");
      
      declare
	 Line : constant String := Get_Line(Project_Files);
      begin
	 Project.Version := To_Version(Line);
      end;
      
      Close(Project_Files);
      delay 0.1;
      Open(Project_Files, In_File, Project_Name & "/Project.lst");
      
      declare
	 Name1 : constant String := Get_Line(Project_Files);
	 Name2 : constant String := Get_Line(Project_Files);
      begin
	 Project.Project_Name := new String ' (Name1);
	 while not End_Of_File(Project_Files) loop
	    declare
	       Line : constant String := Get_Line(Project_Files);
	    begin
	       Lib_Add(Project.all, Line);
	    end;
	 end loop;
      end;
      Close(Project_Files);
      
      Open(Project_Files, In_File, Project_Name & "/Copyright");
      
      declare
	 Author : constant String := Get_Line(Project_Files);
      begin
	 Project.Copyright := new String ' (Author);
      end;
      Close(Project_Files);      
      
   exception
      when Name_Error =>
	 raise;
      when Use_Error =>
	 raise;
      when others =>
	 Project_Free(Project);
	 raise;


   end Read;
   
   procedure Save (Project : in Project_Record; File : in File_Type) is
   begin
      if Project.Project_Name /= null and then
	Project.Project_Name'length /= 0 then
	 Put_Line(File, Project.Project_Name.all & '-' & To_String(Project.Version) & " " & Long_Long_Float'Image(Long_Long_Float(Long_Long_Float(Project.Days)*86400.0)+Long_Long_Float(Project.Elapsed)));
      end if;
   end Save;

end Sky.Project ; 
