-- Skywalker is another attempt of A. i. written with Ada.
-- Skywalker is Copyright (C) 2024 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := 2024-11-22 21:24:47 ; 
-- Version := 0.13.0a ; 
package Sky.Parameters is
   
   type Parameter_Record (Requiered_Parameter : Boolean) is tagged
      record	 
	 Switch   : access Wide_String;	 	 
	 Num_Iter : Natural := 0;	 	 
	 Is_Setted : Boolean := False;	 
	 Parameter_Flag : Flag_Enum := None;	 
	 Descr : access Wide_String;	 
	 case Requiered_Parameter is
	    when False =>
	       null;
	    when True =>
	       
	       param : access Wide_String;
	       Value : access Wide_String;
	 end case;
      end record;
   
   type Parameters_Kit is 
     array (Flag_Enum) of 
     access Parameter_Record;
   
   Line_Parameters : constant Parameters_Kit := 
     (
      
      None => null,
      Config_Filename => new Parameter_Record ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("F"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Config_Filename, 
	 Descr => new Wide_String ' ("Configuration filename"),
	 Param => new Wide_String ' ("Wide_String"),
	 Value => null),
      
      Help => new Parameter_Record '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("h"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => help, 
	 Descr => new Wide_String ' ("print this message")),
      
      Version => new Parameter_Record '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("v"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Version, 
	 Descr => new Wide_String ' ("print the version")),
      Initialize => new Parameter_Record '	
	(Requiered_Parameter => True, Switch => new Wide_String ' ("i"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Initialize, 
	 Descr => new Wide_String ' ("initiaize total value"),
	 Param => new Wide_String ' ("fixed from -999999.99 to 999999.99"),
	 Value => null),
      Total => new Parameter_Record '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("t"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Total, 
	 Descr => new Wide_String ' ("print fixed from -999999.99 to 999999.99")),
      Geometry => new Parameter_Record '	
	(Requiered_Parameter => True, Switch => new Wide_String ' ("g"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => geometry, 
	 Descr => new Wide_String ' ("Descibe the term geometry ; (eg : 67x240)"),
	 Param => new Wide_String ' ("String"),
	 Value => null),
      style => new Parameter_Record '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("s"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => style, 
	 Descr => new Wide_String ' ("style"),
	 Param => new Wide_String ' ("string : Black_And_White, Black_And_Color, Color_And_White" &
				       Wide_Character'Val(10) &
				       "                       White_And_Color, Color_And_Color, White_And_White"),
	 Value => null)
     );
   
   File_Parameters : constant Parameters_Kit := 
     (
      
      None => null,
	 Config_Filename => new Parameter_Record ' 
	   (Requiered_Parameter => True, Switch => new Wide_String ' ("F"), Num_Iter => 0,
	    Is_Setted => False, Parameter_Flag => Config_Filename, 
	    Descr => new Wide_String ' ("Configuration filename"),
	    Param => new Wide_String ' ("Wide_String"),
	    Value => null),
	 
	 Help => new Parameter_Record '
	   (Requiered_Parameter => False, Switch => new Wide_String ' ("h"), Num_Iter => 0,
	    Is_Setted => False, Parameter_Flag => help, 
	    Descr => new Wide_String ' ("print this message")),
	 
	 Version => new Parameter_Record '
	   (Requiered_Parameter => False, Switch => new Wide_String ' ("v"), Num_Iter => 0,
	    Is_Setted => False, Parameter_Flag => Version, 
	    Descr => new Wide_String ' ("print the version")),
      Initialize => new Parameter_Record '	
	(Requiered_Parameter => True, Switch => new Wide_String ' ("i"), Num_Iter => 0,
	    Is_Setted => False, Parameter_Flag => Initialize, 
	    Descr => new Wide_String ' ("initiaize total value"),
	    Param => new Wide_String ' ("fixed from -999999.99 to 999999.99"),
	    Value => null),
      Total => new Parameter_Record '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("t"), Num_Iter => 0,
	    Is_Setted => False, Parameter_Flag => Total, 
	 Descr => new Wide_String ' ("print fixed from -999999.99 to 999999.99")),
      Geometry => new Parameter_Record '	
	(Requiered_Parameter => True, Switch => new Wide_String ' ("g"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => geometry, 
	 Descr => new Wide_String ' ("Descibe the term geometry ; (eg : 67x240)"),
	 Param => new Wide_String ' ("String"),
	 Value => null),
      style => new Parameter_Record '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("s"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => style, 
	 Descr => new Wide_String ' ("style"),
	 Param => new Wide_String ' ("string : Black_And_White, Black_And_Color, Color_And_White" &
				       Wide_Character'Val(10) &
				       "                       White_And_Color, Color_And_Color, White_And_White"),
	 Value => null)
     );
      
end Sky.Parameters ; 
