-- Workstation is attempt of A. i. written with Ada.
-- Workstation is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-08-24 11:28:21"
-- Version := "4.0.47r"
with Ansi_Console;
with Windows_Console;
with Ada.Unchecked_Deallocation;

package Work.Windows is
   
   type Style_Enum is (Black_And_White, Black_And_Color, Color_And_White,
		       White_And_Color, Color_And_Color, White_And_White);
   
   Style : Style_Enum := Color_And_Color;
   
   Line_Max : constant Positive := 67;
   Column_Max : constant Positive := 240;
   
   subtype Line_Range is Positive range 1..1204;
   subtype column_Range is Positive range 1..1204;
   
   function Lines_Max return Line_Range;
   function Cols_Max return Column_Range;
   
   
   Lines : Line_Range := Line_Max;
   Columns : Column_Range := Column_Max;         
   
   package Windows is new Windows_Console(Lines, Columns);
   use Windows;
   
   use Ansi_Console;
   use windows;
   
   type Window_Record is tagged
      record
	 L : Line_Range := 1;
	 C : Column_Range := 1;
	 H : Line_Range := 67;
	 W : Column_Range := 240;	 
	 Text_Color : Color_Type := Cyan;
	 Win : Window_Type;
      end record;
   
   
   
   procedure Initialize (Win : in out Window_Record; 
			 Line_Pos : in Line_Range;
			 Col_Pos : in column_Range;
			 Lines : in Line_Range; 
			 Cols : in Column_Range;
			 Color : in Color_Type;
			 Box_Color : in Color_Type);
   
   procedure Set_Color (Window : in out Window_Record; Color : Color_Type);
   
   procedure Draw_Window (Win : in Window_Record);
   
   procedure Draw_Text (Win : in Window_Record; 
   			Line : in Line_Range;
   			Col : in Column_Range;
   			Color : in Color_Type; Text : in Wide_String);
   
   --  procedure Draw_Text (Win : in Window_Record;
   --  			Line : in Line_Range;
   --  			Col : in Column_Range;
   --  			Color : in Color_Type; Text : in String);
   
   type Win_Access is access all Window_Record;
   procedure Free_Win is new Ada.Unchecked_Deallocation (Window_Record, Win_Access);

end Work.Windows ; 
