-- Workstation is attempt of A. i. written with Ada.
-- Workstation is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-08-14 07:53:20"
-- Version := "4.0.0r"
with work.Attribu;
use Work.Attribu;
with Ada.Calendar;
use Ada.Calendar;
package Work.Types is

   type Tagged_Type is abstract tagged null record;

   type Universe_Record is new tagged_Type with
      record
	 X, Y, Z : Float := 0.0;
	 T       : Time := Time_Of(1970, 01, 01, 0.0);
      end record;
   type Profile_Record is new tagged_Type with
      record
	 Name : String_Access;
	 Born : Time;
      end record;
   type Planning_Record is new tagged_Type with
      record
	 Start : Time;
	 Stop  : Time;
      end record;
   type Event_Record is new tagged_Type with
      record
	 Tag : String_Access;   
	 Date : Time := Clock + 5.0;
	 D    : Duration := 0.0;
      end record;
   type Job_Record is new tagged_Type with
      record
	 Description : String_Access;
      end record;
   type Machine_Record is new tagged_Type with
      record
	 null;
      end record;
   type House_Record is new tagged_Type with
      record
	 null;
      end record;
   type Car_Record is new tagged_Type with
      record
	 Immatriculation : String_Access;
      end record;
   type Account_Record is new tagged_Type with
      record
	 Sum : Float := 0.0;
      end record;
   type Account_Line_Record is new tagged_Type with
      record
	 Sum : Float := 0.0;
      end record;
   type Activity_Record is new tagged_Type with
      record
	 Reason : String_Access;
      end record;
   type Compta_Line_Record is new tagged_Type with
      record
	 Sum : Float := 0.0;
      end record;
   type Component_Record is new tagged_Type with
      record
	 null;
      end record;
   type Contact_Record is new tagged_Type with
      record
	 null;
      end record;
   type Content_Record is new tagged_Type with
      record
	 Price : Float := 0.0;
	 Content : String_Access;
      end record;
   type Note_Record is new tagged_Type with
      record
	 null;
      end record;
   
end Work.Types ; 
