-- Workstation is attempt of A. i. written with Ada.
-- Workstation is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-08-14 07:53:20"
-- Version := "4.0.0r"

with Ada.Text_Io;
with Work.Attribu;                                   use Work.Attribu;
with Work.Types;
use Work.Types;
with Ada.Containers.Vectors;
with M.Windows; 
with M.Ansi.Console;
generic
   with package Windows is new M.Windows (<>);
package Work.Classes is
   use Windows;   
   use Windows.Ansi_Windows;
   use M.Ansi.Console;
   
   package T_Io renames Ada.Text_Io;
   
   type Abstracted_Class;
   type Abstracted_Access is access all Abstracted_Class;  
   subtype Abstracted_Index is Positive;
   function "=" (Left, Right : in Abstracted_Access) return Boolean;
   package Abstracted_Vectors is new Ada.Containers.Vectors (Abstracted_Index, Abstracted_Access, "=");
   
   type Abstracted_Class is tagged
      record
	 Ref       : String_Access;
	 Definition : Attribute_Vectors.Vector;
	 Properties : Attribute_Vectors.Vector;
	 Parents    : Abstracted_Vectors.Vector;
      end record;
   
   type Obj_Enum is (Note, Profile, Contact, Car, House,
		     Content, Planning, Event, Universe, Activity,
		     Compta_Line, Acc, Account_Line, Job, Machine, Component);
   type Object_Class (Class_Name : Obj_Enum) is abstract new Abstracted_Class with
      record
	 case Class_Name is
	    when Note => Note : Note_Record;
	    when Profile => Profile : Profile_Record;
	    when Contact => Contact : Contact_Record;
	    when Car => Car : Car_Record;
	    when House => House : House_Record;
	    when Content => Content : Content_Record;
	    when Planning => Planning : Planning_Record;
	    when Event => Event : Event_Record;
	    when Universe => Universe : Universe_Record;
	    when Activity => Activity : Activity_Record;
	    when Compta_Line => Compta_Line : Compta_Line_Record;
	    when Acc => Account : Account_Record;
	    when Account_Line => Account_Line : Account_Line_Record;
	    when Job => Job : Job_Record;
	    when Machine => Machine : Machine_Record;
	    when Component => Component : Component_Record;
	 end case;
      end record;
   
   procedure Write (O : in Object_Class;File : in T_Io.File_Type) is abstract;
   procedure Read (O : in out Object_Class;File : in T_Io.File_Type) is abstract;
   
   procedure Print (O : in Object_Class) is abstract;
   procedure Print (O : in Object_Class; Win : in Window_Record; Index : in out Natural) is abstract;
   
   type Object_Access is access all Object_Class ' Class;
   
   function Fit (Object : in Object_Class) return Float is abstract;
   procedure Mutate(Object : in out Object_Class) is abstract;
   function Mute(Left : in Object_Class; 
		 Right : in Object_Class'class) return Object_Class is abstract;
   
   subtype Object_Index is Positive;
   function "=" (Left, Right : in Object_Access) return Boolean;
   package Object_Vectors is new Ada.Containers.Vectors (Object_Index, Object_Access, "=");
   
end Work.Classes ; 
