-- Workstation is attempt of A. i. written with Ada.
-- Workstation is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-08-14 07:53:20"
-- Version := "4.0.0r"
with Text_Io;
package body Work.Classes.Content_Class is
   
   function Fit (Content : in Content_Obj) return Float is
   begin
      return 0.0;
   end Fit;
   
   procedure Mutate(Content : in out Content_Obj) is
   begin
      null;
   end Mutate;
   
   function Mute(Left : in Content_Obj; 
		 Right : in Object_Class'class) return Content_Obj is
      O : Content_Obj;
   begin
      return O;
   end Mute;
           
   procedure Write (O : in Content_Obj;File : in T_Io.File_Type) is
   begin
      null;
   end Write;
   
   procedure Read (O : in out Content_Obj;File : in T_Io.File_Type) is
      
   begin
      
      O.Content.Content := new String ' (Text_Io.Get_Line(File));
      
      O.Content.Price := Float'Value(Text_Io.Get_Line(File));
      
   end Read;
   
   procedure Print (O : in Content_Obj) is
   begin
      if O.Content.Content /= null then
	 Text_Io.Put_Line("Content : " & O.Content.Content.all);
      else
	 Text_Io.Put_Line("Content : empty");
      end if;
      
      Text_Io.Put_Line("Price : " & Float'Image(O.Content.Price));
   end Print;
   procedure Print (O : in Content_Obj; Win : in Window_Record; Index : in out Natural) is
   begin 
      if Index + 2 >= Win.Win.H-2 then return; end if;
      Index := Index + 1;
      if O.Content.Content /= null then
	 Draw_Text(Win, Index, 1, Cyan, To_Wide_String("Content : " & O.Content.Content.all));	 
      else	 
	 Draw_Text(Win, Index, 1, Cyan, To_Wide_String("Content : empty"));	 
      end if;
      Index := Index + 1;
      Draw_Text(Win, Index, 1, Cyan, To_Wide_String("Price : " & Float'Image(O.Content.Price)));
      
   end Print;

end Work.Classes.Content_Class ; 
