-- Workstation is attempt of A. i. written with Ada.
-- Workstation is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-08-14 07:53:20"
-- Version := "4.0.0r"
with Ada.Containers.Vectors;
package Work.Attribu is
   
   
   type String_Access is access all String;
   
   type Name_Enum is (Bool, Int, Flt, Char, Str);
   
   type Attribute_Class(Attr_Name : Name_Enum) is tagged
      record
	 Name  : String_Access;
	 Image : String_Access;
	 case Attr_Name is
	    when Bool =>
	       Verax : Boolean := False;
	    when Int =>
	       Value : Integer := 0;
	    when Flt =>
	       Real : Float := 0.0;
	    when Char =>
	       Char : Character := ' ';
	    when Str =>
	       Line : String_Access;
	 end case;
      end record;
   
   type Attribute_Access is access all Attribute_Class;
   
   subtype Attribute_Index is Positive;
   
   function "=" (Left, Right : in Attribute_Access) return Boolean;
   
   package Attribute_Vectors is new Ada.Containers.Vectors (Attribute_Index, Attribute_Access, "=");
   
   
end Work.Attribu ; 
