-- Skywalker is another attempt of A. i. written with Ada.
-- Skywalker is Copyright (C) 2024 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := 2024-11-17 09:31:38 ; 
-- Version := 0.1.0r ; 
with Sky.Stock;
use Sky.Stock;

package Sky.Stocks_manager is
   
   
   
   type Stock_Array is array (Stock_Num_Range range <>) of Stock_Record;
   
   type Stocks_Manager (Stocks_Max : Stock_Num_Range) is
      record
	 Stocks : Stock_Array(1..Stocks_Max);
	 Stock_Last : Stock_Num_Range := 0;
      end record;
   
   procedure Stock_Add (To : in out Stocks_Manager;
			Stock : in Stock_Record);
   -- Spec_Error is raised if no space left.   
   
   
   
   procedure Stock_Remove (From : in out Stocks_Manager;
			   Stock_Num : in Stock_Num_Range);
   
   Not_An_Stock : exception; 
   -- Not_An_Stock is raised when not Stock_Num is not an stock.
   
   procedure Add_To_Stock(From : in out Stocks_Manager;
			  Stock_Num : in Stock_Num_Range;
			  Qt  : in Quantity_Range);
   -- If the stock more Qt is over Quantity_Range'last, Spec_error is raised.
   procedure Add_To_Stock(From : in out Stocks_Manager;
			  Name : in Wstring_32;
			  Qt  : in Quantity_Range);
   -- If the stock more Qt is over Quantity_Range'last, Spec_error is raised.
   
   procedure Update_Stock(To: in out Stocks_Manager;
			  Stock : in Stock_Record);
   -- If the stock more Qt is over Quantity_Range'last, Spec_error is raised.
   
   
   procedure Remove_From_Stock(From : in out Stocks_Manager;
			       Name : in Wstring_32;
			       Qt  : in Quantity_Range);
   -- if Qt is not in the stock, Spec_Error is raised.
   
   function In_Stocks (Stocks : in Stocks_Manager; Description : in Wstring_32) return Boolean;
   
   
   Software : Stocks_Manager(256);
   
   Soft_num : Natural := 0;
     
   Hardware : Stocks_Manager(128);
   
   Hard_Num : Natural := 0;
   
   Hard_Filename : constant String := "hardstock.txt";
   Soft_Filename : constant String := "softstock.txt";
   
   procedure Stocks_Save;
   procedure Stocks_Restore;

end Sky.Stocks_manager ; 
