-- Skywalker is another attempt of A. i. written with Ada.
-- Skywalker is Copyright (C) 2024 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := 2024-11-19 17:59:11 ; 
-- Version := 0.7.0r ; 

with Gnat.Os_Lib;
use Gnat.Os_Lib;   
with Ada.Calendar;
use Ada.Calendar;
package Sky.Attributes is
   
         type All_Types is tagged
	 record
	    Boo  : Boolean;
	    Int  : Integer;
	    Flt  : Float;	    
	    Date : Time := Clock;
	    Str  : String_Access;	    
	 end record;
      
      type attribut_Enum is (Nil, Boo, Int, Flt, Date, Str);
      
      type Attribut_Record is new All_Types with
	 record
	    name  : String_Access;
	    Value : String_Access;
	    Enum  : Attribut_Enum;
	 end record;            
      
      
      
      type Attribut_Array is array (Positive range <>) of Attribut_Record;
      
      type Attributs (Max : Positive) is
	 record
	    List : Attribut_Array(1..Max);
	    Index : Natural := 0;
	 end record;

      procedure Parse (Line : in String; Name : out String_Access; Image : out String_Access);
      
      function Make (Names : in String; Value : in String) return Attribut_Record;
      function names (Att : in Attribut_Record) return String;
      function images (Att : in Attribut_Record) return String;

end Sky.Attributes ; 
