package Sai is   
   pragma Pure (Sai);
   
   
type Id_Range is (Name, Email, Address, Phone, Skywalker, SKYBUSINESS, skyserver, Null_Item, Objectif, Motivations, Objet, arguments);

   subtype Name_Wide_String is Wide_String(1..32);
   subtype Email_string is String(1..48);
   subtype Address_Wide_String is Wide_String(1..64);
   subtype Phone_string is String (1..16);
   
   type Coordonates_Type is tagged
      record
	 Name    : Name_Wide_String := (others => ' ');
	 Email   : Email_String := (others => ' ');
	 Address : Address_Wide_String := (others => ' ');
	 Phone   : Phone_String := (others => ' ');
      end record;
      
   subtype Program_String is  String (1..24);
   
   type Program_Array is array (1..10) of Program_String;
   
   type Price_Type is delta 0.01 range 0.0..4_9999_999.99;
      
   subtype Product_Enum is Id_Range range Skywalker..Null_item;
   
   type Price_Array is array (Product_Enum) of Price_Type;   
   
   My_Prices : constant Price_Array :=
     (Skywalker => 177.76,
skybusiness=>  78.70,
skyserver=>  212.02,


      Null_Item => 0.0);
      
      
      
      
      
      
      
      
      

   
   subtype Card_Num_Type is Wide_String(1..14);
   
   
   subtype Exp_Type is Wide_String (1..7);
   
   subtype Sign_Type is Wide_string (1..3);

   
   subtype Name_String is Wide_String(1..32);
   
   
   type Bank_Info_Type is
      record
	 Card_Num : Card_Num_Type := (others => ' ');
	 Sign     : Sign_Type := (others => ' ');
	 Exp      : Exp_Type := (others => ' ');
	 Name     : Name_String :=  (others => ' ');
      end record;
	   
   Null_Card : constant Bank_Info_Type := ((others => ' '),  (others => ' '),  (others => ' '),  (others => ' '));
   
   
   
   
   type Client_Record is new Coordonates_Type with
      record
	 Bank_card       : Bank_Info_Type := Null_Card;
	 Id_Transaction  : Natural := 0;
	 Payed           : Boolean := False;
      end record;
   
   type Command_Record is new Client_Record with
      record
	 Products : Price_Array := (others => 0.0);
	 Ht_Sum   : Price_Type := 0.0;
	 TVA      : Price_Type := 0.0;
	 TTC_Sum  : Price_Type := 0.0;
	 Coordonatess : Coordonates_Type;	 
	 
      end record;
   
   type Facture_Record is new Command_Record with null record;
   
   subtype Objectif_String is Wide_String(1..255);
   subtype Motivations_String is Wide_String(1..255);
   subtype Objet_String is Wide_String(1..255);
   subtype Arguments_String is Wide_String(1..255);
   
   
   type Logiciel_Type is tagged
      record
	 Objectif    : Objectif_String := (others => ' ');
	 Motivations : Motivations_String := (others => ' ');
	 Objet       : Objet_string := (others => ' ');
	 Arguments   : Arguments_String  := (others => ' ');
      end record;
   
   
   type Solution_Enum is (Carte, Outils, Utilitaire, Application, Progiciel, System);
   
   
   
   type Forfait_Enum is (None, Charge, Etude, Architecture, Computation, Marcher, Enquete, Sondage, Web_Site, Informatisation, Prestation);
   
   type Carte_Type is array (Forfait_Enum) of Boolean;
   
   
   type Method_Enum is (None, Genetical, Search, Finding, Neural, Reenforcing);
   
   type Context_Enum is (Ada, Gtk, Assemblage, SQL);
   
   type Context_Type is array (Context_Enum) of Boolean;
   
   type Process_Enum is (Manuel, Automatique);
   
   type Int_Enum is (None, Cmd_Line, Win, Network, html);
   
   type Int_Type is array (Int_Enum) of Boolean;
   
   type Solution_Model_Type is tagged
      record
	 Name      : Name_String := (others => Wide_Character'Val(32));
	 Axiomatic : Wide_String(1..4096) := (others => ' ');
	 Formule   : Solution_Enum := Carte;
	 Forfaits  : Carte_Type := (others => False);
	 Method    : Method_Enum := None;
	 Contexts  : Context_Type := (True, False, False, False);
	 Process   : Process_Enum := Manuel;
	 Ints      : Int_Type := (others => False);
      end record;
   
   
   
   type Enregistrement_Record is tagged
      record
	 Coordonates : Coordonates_Type;
	 Programs    : Program_Array := (others => (others => ' '));
	 Logicial    : Logiciel_Type;
	 Solution    : Solution_Model_Type;
      end record;
   
   type Command_Enum is (Null_Item, Cmd, Validation, Paiement);
   
end Sai;
