with Text_Io;
with M.Strings;
use M.Strings;
with Ada.Wide_Text_Io;
use Ada.Wide_Text_Io;
with Ada.Characters.Handling;
use Ada.Characters.Handling;
with Sai.Shared;
use Sai.Shared;
package body Sai.Editting is
   
   
   function Id_Line return Wide_String is
      Line : Wide_String_Access;
      Top : constant Wide_String := "type Id_Range is (Name, Email, Address, Phone, Skywalker, ";
      Bot : constant Wide_String := "Null_Item, Objectif, Motivations, Objet, arguments);";
      Buff : Wide_String_Access := new Wide_String ' (Top);
   begin
      Line := new Wide_String ' (Buff.all);
      Wide_Free(Buff);
      for Id in 2..Id_Count loop
	 Buff := new Wide_String ' (Line.all & To_Wide_String(Name((Id)+4).all) & ", ");
	 Wide_Free(Line);
	 Line := new Wide_String ' (Buff.all);
	 Wide_Free(Buff);
      end loop;
      Buff := new Wide_String ' (Line.all & Bot);
      Wide_Free(Line);
      Line := new Wide_String ' (Buff.all);
      Wide_Free(Buff);
      return Line.all;
   end Id_Line;
   
   
   
   
   procedure Add_Edit(Path : in String; Name : in String; Price : in Price_Type) is
      Set : Wide_String_Set(115);
      File : File_Type;
      Last : Natural := 1;
      Line : Wide_String_Access;
   begin
      Line := new Wide_String ' (Id_Line);
      Open(File, In_File, Path & '/' & "src/lib/sai.ads", Form => "WCEM=8");

      while not End_Of_File(File) loop
	 Add_Line(Set, Last, Get_Line(File));
      end loop;

      Close(File);
      Wide_Free(Set.Lines(5));
      Set.Lines(5) := new Wide_String ' (Line.all);

      for Count in reverse 32+(Id_Count-1)..Last loop
	 Set.Lines(Count+1) := Set.Lines(Count);
      end loop;
      Wide_Free(Set.Lines(31+(Id_Count-1)));
      Set.Lines(31+(Id_Count-1)) := new Wide_String ' (To_Wide_String(Names(Id_Count+4).all) & "=> " & To_Wide_String(Price_Type'Image(Price)) & ',');
      Create(File, Out_File, Path & '/' & "src/lib/sai.ads", Form => "WCEM=8");
      for Count in Set.Lines'Range loop
	 if Set.Lines(Count) /= null then
	    Put_Line(File, Set.Lines(Count).all);
	 end if;
      end loop;
      Close(File);

   end Add_Edit;
   
   procedure Del_Edit(Path : in String; Id : in Product_id) is
      Set : Wide_String_Set(115);
      File : File_Type;
      Last : Natural := 1;
      Line : constant Wide_String_Access := new Wide_String ' (Id_Line);
   begin
      Open(File, In_File, Path & '/' & "src/lib/sai.ads", Form => "WCEM=8");

      while not End_Of_File(File) loop
	 Add_Line(Set, Last, Get_Line(File));
      end loop;

      Close(File);
      Wide_Free(Set.Lines(Positive'Value(To_String(Line.all))));
      Set.Lines(Positive'Value(To_String(Line.all))) := new Wide_String ' (Line.all);

      Wide_Free(Set.Lines(31+(Id-1)));
      for Count in 32+(Id-1)..Last-1 loop
	 Set.Lines(Count) := Set.Lines(Count+1);
      end loop;
      Create(File, Out_File, Path & '/' & "src/lib/sai.ads", Form => "WCEM=8");
      for Count in Set.Lines'Range loop
	 if Set.Lines(Count) /= null then
	    Put_Line(File, Set.Lines(Count).all);
	 end if;
      end loop;
      Close(File);

   end Del_Edit;
   
   procedure Init is
   begin
      for id in Id_range loop
	 Names (Id_Range'Pos(Id)) := new String ' (Id_Range'Image(Id));
      end loop;
   end Init;
   procedure Del(Id : in Product_Id) is
   begin
      if Id_Count > 1 then
	 for Name in Id+1..Names'Length-1 loop
	    Names(Name-1) := Names(Name);
	 end loop;
	 Id_Count := Id_Count - 1;
      end if;
   end Del;
	   
   procedure Add(Name : in String) is
   begin

      for Id in reverse Id_Count+5..Names'Length-1 loop
	 Names(Id-1) := Names(Id-2);
      end loop;

      Names(Id_Count + 5) := new String ' (Name);

      Id_Count := Id_Count + 1;      
   end Add;
   
   function Name (Id : in Product_Id) return Id_Name is
   begin
      return Names(Id);
   end Name;
end Sai.Editting;
