--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Gnostic is Ada Generic Neural Object System Engineering.                                                                                                --
-- Gnostic (C) Copyright 2016 Manuel De Girardi.                                                                                                           --
--------------------------------------------------------------------------------------------------------------------------------------------------------------
  
--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Date        := 2016-12-06 15:54:11 ; 
-- Description : Ada Generic Neural Object System Engineering.                                                                                              --
-- Version     := 2016.35.1a ; 
-- Authors     : Manuel De Girardi.                                                                                                                         --
--------------------------------------------------------------------------------------------------------------------------------------------------------------
package Gnos.Versions is
   
   pragma Shared_Passive (Gnos.Versions);
   
   subtype Major_Version_Type is Natural range Natural'First .. 2399;
   subtype Minor_Version_Type is Natural range Natural'First .. 366;
   subtype Revision_Version_Type is Natural range Natural'First .. 86400;
   subtype Release_Version_Type is Character range 'a' .. 'z' ; 
         
   -- Initiale version :
   Current_Major    : constant Major_Version_Type    := 3 ; 
   Current_Minor    : constant Minor_Version_Type    := 6 ; 
   Current_Revision : constant Revision_Version_Type := 14 ; 
   Current_Release  : constant Release_Version_Type  := 'r' ; 
      
   type Version_Type is
      record
	 Major_Version    : Major_Version_Type := Major_Version_Type'First;
	 Minor_Version    : Minor_Version_Type := Minor_Version_Type'First;
	 Revision_Version : Revision_Version_Type := Revision_Version_Type'First;
	 Release_Version  : Release_Version_Type := Release_Version_Type'First;
      end record;
      
   Null_Version : constant Version_Type := 
     (Major_Version => Major_Version_Type'First,
      Minor_Version => Minor_Version_Type'First,
      Revision_Version => Revision_Version_Type'First,
      Release_Version => Release_Version_Type'First);

   Version : Version_Type := 
     (Major_Version => Current_Major,
      Minor_Version => Current_Minor,
      Revision_Version => Current_Revision,
      Release_Version => Current_Release);
   
   
   New_Action      : Boolean := False;
   New_Description : Boolean := False;
   New_Version     : Boolean := True;
   
   
   subtype Year_Number  is Integer range 1901 .. 2399;
   subtype Month_Number is Integer range 1 .. 12;
   subtype Day_Number   is Integer range 1 .. 31;
   subtype Day_Duration is Duration range 0.0 .. 86_399.0;
   
   
   
   
   type date_Type is 
      record
         Year    :    Year_Number   := Year_Number'First;
         Month   :    Month_Number  := Month_Number'First;
         Day     :    Day_Number    := Day_Number'First;
         Hours   :    Day_Duration  := Day_Duration'First;
      end record;
   
   shared_Date : Date_Type := (Year_Number'First, 
			      Month_Number'First, 
			      Day_Number'First,
			      Day_Duration'First);        
   
   
   Start_Date : Date_Type := (Year_Number'First, 
                                    Month_Number'First, 
                                    Day_Number'First,
                                    Day_Duration'First);        
   
   Date_Locked : Boolean := False;
   type Timer_Type is
      record
         Start_Date : Date_Type := (Year_Number'First, 
                                    Month_Number'First, 
                                    Day_Number'First,
                                    Day_Duration'First);        
         Is_Set     : Boolean := False;
      end record;
   
   Shared_Timer : Timer_Type := ((Year_Number'First, 
                                  Month_Number'First, 
                                  Day_Number'First,
                                  Day_Duration'First),
                                 False);
   
   type Alarm_Type is
      record
   
         Start_Date : Date_Type := (Year_Number'First, 
                                    Month_Number'First, 
                                    Day_Number'First,
                                    Day_Duration'First);
         Stop_Date  : Date_Type := (Year_Number'First, 
                                    Month_Number'First, 
                                    Day_Number'First,
                                    Day_Duration'First);
         Is_Set     : Boolean := False;
      end record;
   
   
         
   Shared_Alarm : Alarm_Type := ((Year_Number'First, 
                                  Month_Number'First, 
                                  Day_Number'First,
                                  Day_Duration'First),
                                 (Year_Number'First, 
                                 Month_Number'First, 
                                 Day_Number'First,
                                 Day_Duration'First),
                                 False);
     

end Gnos.Versions;
