--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Gnostic is Ada Generic Neural Object System Engineering.                                                                                                --
-- Gnostic (C) Copyright 2016 Manuel De Girardi.                                                                                                           --
--------------------------------------------------------------------------------------------------------------------------------------------------------------
  
--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Date        := 2016-11-27 19:33:08 ; 
-- Description : Ada Generic Neural Object System Engineering.                                                                                              --
-- Version     := 2016.12.1a ; 
-- Authors     : Manuel De Girardi.                                                                                                                         --
--------------------------------------------------------------------------------------------------------------------------------------------------------------
with Gnos.Options;
package Gnos.Parameters is      
   
   
      
   
   
   type Projects_Parameters_Type is new Parameters_Kit_Record with
      record
	 Name_Length : Name_Index_Type := 1024;
	 Unit_Max    : Unit_Index_Type := 1024;
	 With_Gtk : Boolean := False;
	 With_Ada : Boolean := False;
	 With_Aws : Boolean := False;
      end record;      
   
   type Language_Parameters_Type is new Projects_Parameters_Type with
      record
	 Char_Max	: char_index_type := 256;
	 Version        : version_index_type := 2016;
      end record;
      
   type Objects_Parameters_Type is new Language_Parameters_Type with
      record
	 Objects_Max : Object_Index_Type := 65536;	 
      end record;
         
   type System_Parameters_Type is new Objects_Parameters_Type with
      record
	 Self_Programming	: boolean := False;
	 Self_Executed		: boolean := False;	 
      end record;
      
   type Neural_Parameters_Type is new System_Parameters_Type with
      record
	 Self_Wait : Duration := 0.00005;
	 User_Wait : Duration := 86400.0;
      end record;
   
   type Gnose_Parameters_Type is new Neural_Parameters_Type with
      record
	 Human_Lang : Human_Lang_Enum := Human_Lang_Enum'First;
      end record;
   
   
   procedure initialize(Gnose_Parameters : in out Gnose_Parameters_Type; End_Of_Task : out boolean);
   
   function Set_Parameters_From
     
     (Filename : in Wide_String) 
     
     return Parameters_Kit_Record;
   
   use Gnos.Options;
   procedure Set_Parameters(the_Parameters : out Parameters_Kit_Record;			    
			    Options_Kit : in Options_Kit_Array_Type);
   
   
   function Get_Parameter
     (From : in Parameters_Kit_Array_Type;
      Flag : in Parameters_Flags_Enum_Type)
     return Parameter_Tagged_Record_Type;   
   
   procedure Parameters_Descriptions
     (From : in Parameters_Kit_Array_Type);
   
   procedure Print_Parameters (Kit : in Parameters_Kit_Array_Type);
   
   procedure All_Parameters(All_Params : in out Gnose_Parameters_Type);
   
end Gnos.Parameters;
