--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Gnostic is Ada Generic Neural Object System Engineering.                                                                                                --
-- Gnostic (C) Copyright 2016 Manuel De Girardi.                                                                                                           --
--------------------------------------------------------------------------------------------------------------------------------------------------------------
  
--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Date        := 2016-11-27 19:33:08 ; 
-- Description : Ada Generic Neural Object System Engineering.                                                                                              --
-- Version     := 2016.12.1a ; 
-- Authors     : Manuel De Girardi.                                                                                                                         --
--------------------------------------------------------------------------------------------------------------------------------------------------------------
with Gnos.Parameters;
with Gnos.Projects;
generic   
   
   Params : Parameters.Language_Parameters_Type;
package Gnos.Machines is
   use Parameters;
   package Agnose_Projects is new Gnos.Projects(Projects_Parameters_Type(params));
   Machines_Params : Parameters.Language_Parameters_Type := Params;
   
   use Agnose_Projects;
   
   type Language_Context_Record is new Projects_Context_Record with
      record
	 Language_Params  : Parameters.Language_Parameters_Type := Machines.Params;	 
      end record;

   
   procedure initialize(Language_Context : in out Language_Context_Record;
			Language_Params  : in Language_Parameters_Type);			
   procedure Load_project(Language_Context : in out Language_Context_Record;			
			Ada_Path : in String;
			Gtk_Path : in String;
			Aws_Path : in String;
			Project_Path : in String);
   
   function Check_Parameters(Language_Context : in Language_Context_Record'class;
			     Params : in Language_Parameters_Type'class) return Boolean;      
	

    type Language_unit_record is tagged
	record
	   Machine_Lang : Machine_Lang_Enum := Machine_Lang_Enum'First;
	end record;
   type Language_Unit_Access is access all Language_Unit_record;
   type Language_set_array_type is array (Machine_Lang_Enum range <>) of Language_Unit_Access;
   type Language_set_access is access Language_Set_array_type;
   type Language_System is tagged
      record	 
	 Language_set : Language_set_access;
      end record;
   
   procedure Load_Language(Language_Set : in out Language_Set_Array_Type; Machine_Lang : in Machine_Lang_Enum);
   
   
end Gnos.Machines;
