-- Date := 2016-11-27 23:02:04 ; 
-- Version := 2016.17.1a ; 

package body Gnos.Lexical is
      package body Code_Random is
	 
	 Alphabet : constant String := "abcdefghijklmnopqrstuvwxyz";
	 
	 subtype Digit_Type is Positive range 1..Alphabet'Length;
	 
	 package Digit_Random is new Ada.Numerics.Discrete_Random(Digit_Type);
	 use Digit_Random;
	 Digit_Gen : Digit_Random.Generator;
	 
	 procedure  Reset is
	 begin
	    Reset(Digit_Gen);
	 end Reset;
	 
	 function Random(Length : in Positive) return String is
	    
	    Code : String(1..Length);
	    Lock : Boolean := True;
	    Char : Character;
	    Index : natural := 0;
	 begin	    
	    while Index + 1 <= Length loop	       
	       char := Alphabet(Random(Digit_Gen));
	       if Index + 1 = Length then
		  Lock := True;
	       end if;
	       if not Lock then
		  if char = '.' or char = '-' then
		     Lock := True;
		  end if;
		  Code(Index + 1) := Char;
		  Index := Index + 1;
	       elsif char /= '.' and char /= '-' then		  
		  Code(Index + 1) := Char;
		  Index := Index + 1;		  		  
		  Lock := False;	       
	       end if;
	    end loop;	    
	    return Code;
	 end Random;
      end Code_Random;

      
end Gnos.Lexical;

