--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Gnostic is Ada Generic Neural Object System Engineering.                                                                                                --
-- Gnostic (C) Copyright 2016 Manuel De Girardi.                                                                                                           --
--------------------------------------------------------------------------------------------------------------------------------------------------------------


--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Date        := 2016-11-27 19:33:08 ; 
-- Description : Ada Generic Neural Object System Engineering.                                                                                              --
-- Version     := 2016.12.1a ; 
-- Authors     : Manuel De Girardi.                                                                                                                         --
--------------------------------------------------------------------------------------------------------------------------------------------------------------
with Gnos.Parameters;
with Gnos.Neural;
with Ada.Calendar;
use Ada.Calendar;

generic      
   Params : Parameters.Gnose_Parameters_Type;
   
package Gnos.Gnose is
   
   use Parameters;
   Neural_params : constant Neural_Parameters_Type := Neural_Parameters_Type(params);
   package Neural is new Gnos.Neural(Neural_Params);
   
   
   
   type Gnose_Context_Record is new Neural.Neural_Context_Record with
      record	 
	 Gnose_Params : Parameters.Gnose_Parameters_Type;	 
      end record;	       
   
   use Neural;
   use Neural.Objects_System;
   use Neural.Objects_System.Objects_System;
   use Neural.Objects_System.Objects_system.Language;
   use Neural.Objects_System.Objects_System.Language.Agnose_Projects;
   
   
   
   procedure initialize(Gnose_Context : in out Gnose_Context_Record;
			Gnose_Params  : in out Gnose_Parameters_Type);
   
   procedure Load_Project(Gnose_Context : in out Gnose_Context_Record;
			  Ada_Path : in String;
			  Gtk_Path : in String;
			  Aws_Path : in String;
			  Project_Path : in String);
   
   
   
   
   function Check_Parameters(Gnose_Context : in Gnose_Context_Record; Params : in Gnose_Parameters_Type) return Boolean;     
   
   
   procedure Print_Context (Gnose_Context : in Gnose_Context_Record);
   

   
end Gnos.Gnose;
