--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Gnostic is Ada Generic Neural Object System Engineering.                                                                                                --
-- Gnostic (C) Copyright 2016 Manuel De Girardi.                                                                                                           --
--------------------------------------------------------------------------------------------------------------------------------------------------------------

--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Date        := 2016-11-27 19:33:08 ; 
-- Description : Ada Generic Neural Object System Engineering.                                                                                              --
-- Version     := 2016.12.1a ; 
-- Authors     : Manuel De Girardi.                                                                                                                         --
--------------------------------------------------------------------------------------------------------------------------------------------------------------
with Ada.Wide_Text_Io;
with Ada.Text_Io;
use Ada;

package body Gnos.Gnose is
         
   
   procedure initialize(Gnose_Context : in out Gnose_Context_Record;
			Gnose_Params  : in out Gnose_Parameters_Type) is
      
      
   begin            
      
      
      
      null;
      Gnose_Context.Gnose_Params := Gnose_Params;
      Neural.Initialize(Neural_Context_Record(Gnose_Context), Parameters.Neural_Parameters_Type(Gnose_Params));
   end initialize;
   
   
   procedure Load_Project(Gnose_Context : in out Gnose_Context_Record;
			  Ada_Path : in String;
			  Gtk_Path : in String;
			  Aws_Path : in String;
			  Project_Path : in String) is
      
      
      
   begin
      
      Neural.Load_Project(Neural_Context_Record(Gnose_Context), 
		  Ada_Path, Gtk_Path, Aws_Path, Project_Path);            
      
   end Load_Project;
   
   
   function Check_Parameters(Gnose_Context : in Gnose_Context_Record; Params : in Gnose_Parameters_Type) return Boolean is
      
      Checked : Boolean := False;
      Neural_Context : Neural_Context_Record := Neural_Context_Record(Gnose_Context);
   begin
      Wide_Text_Io.Put("Gnose Context :");
      
      Checked := Gnose_Context.Gnose_Params = Params;
      if not Checked then
	 Text_Io.New_Line;
	 if Gnose_Context.Gnose_Params.Human_Lang /= Gnose_Parameters_Type(Params).Human_Lang then
	    
	    Text_Io.Put_Line("Human_Lang : " & 
		       Human_Lang_Enum'Image(Gnose_Context.Gnose_Params.Human_Lang) & " /= " &
			       Human_Lang_Enum'Image(Gnose_Parameters_Type(Params).Human_Lang));
	 end if;
	 raise Program_Error;
      end if;
      Wide_Text_Io.Put("Ok, ");
      Checked := Checked and Neural.Check_Parameters(Neural_Context, Neural_Parameters_Type(Params));
      return Checked;
   end Check_Parameters;
   
   procedure Print_Context (Gnose_Context : in Gnose_Context_Record) is
   begin
      
      --  Text_Io.Put_Line("Human_Lang : " & 
      --  			 Human_Lang_Enum'Image(Gnose_Context.Gnose_Params.Human_Lang));

      --  Text_Io.Put_Line("Self_Wait : " & 
      --  		 Duration'Image(Gnose_Context.Gnose_Params.Self_Wait));

      
      --  Text_Io.Put_Line("User_Wait : " & 
      --  		 Duration'Image(Gnose_Context.Gnose_Params.User_Wait));
      
      --  Text_Io.Put_Line("Self_Programming : " & 
      --  			 Boolean'Image(Gnose_Context.Gnose_Params.Self_Programming));
      
      --  Text_Io.Put_Line("Self_Executed : " & 
      --  			 Boolean'Image(Gnose_Context.Gnose_Params.Self_Executed));
      
      --  Text_Io.Put_Line("Objects_Max : " & 
      --  			 Integer'Image(Gnose_Context.Gnose_Params.Objects_Max));
      
      --  Text_Io.Put_Line("Char_Max : " & 
      --  			 Integer'Image(Gnose_Context.Gnose_Params.Char_Max));
      
      --  Text_Io.Put_Line("Version : " & 
      --  			 Integer'Image(Gnose_Context.Gnose_Params.Version));
      
      --  Text_Io.Put_Line("Name_Length : " & 
      --  			 Integer'Image(Gnose_Context.Gnose_Params.Name_Length));
      
      --  Text_Io.Put_Line("Unit_Max : " & 
      --  			 Integer'Image(Gnose_Context.Gnose_Params.Unit_Max));
      
      --  Text_Io.Put_Line("With_Gtk : " & 
      --  			 Boolean'Image(Gnose_Context.Gnose_Params.With_Gtk));
      
      --  Text_Io.Put_Line("With_Ada : " & 
      --  			 Boolean'Image(Gnose_Context.Gnose_Params.With_Ada));
      
      --  Text_Io.Put_Line("With_Aws : " & 
      --  			 Boolean'Image(Gnose_Context.Gnose_Params.With_Aws));
      
      Text_Io.Put_Line("Human_Lang : " & 
			 Human_Lang_Enum'Image(Gnose_Context.Gnose_Params.Human_Lang));

      Text_Io.Put_Line("Self_Wait : " & 
		 Duration'Image(Gnose_Context.Neural_Params.Self_Wait));

      
      Text_Io.Put_Line("User_Wait : " & 
		 Duration'Image(Gnose_Context.Neural_Params.User_Wait));
      
      Text_Io.Put_Line("Self_Programming : " & 
			 Boolean'Image(Gnose_Context.System_Params.Self_Programming));
      
      Text_Io.Put_Line("Self_Executed : " & 
			 Boolean'Image(Gnose_Context.System_Params.Self_Executed));
      
      Text_Io.Put_Line("Objects_Max : " & 
			 Integer'Image(Gnose_Context.Objects_Params.Objects_Max));
      
      Text_Io.Put_Line("Char_Max : " & 
			 Integer'Image(Gnose_Context.Language_Params.Char_Max));
      
      Text_Io.Put_Line("Version : " & 
			 Integer'Image(Gnose_Context.Language_Params.Version));
      
      Text_Io.Put_Line("Name_Length : " & 
			 Integer'Image(Gnose_Context.Projects_Params.Name_Length));
      
      Text_Io.Put_Line("Unit_Max : " & 
			 Integer'Image(Gnose_Context.Projects_Params.Unit_Max));
      
      Text_Io.Put_Line("With_Gtk : " & 
			 Boolean'Image(Gnose_Context.Projects_Params.With_Gtk));
      
      Text_Io.Put_Line("With_Ada : " & 
			 Boolean'Image(Gnose_Context.Projects_Params.With_Ada));
      
      Text_Io.Put_Line("With_Aws : " & 
			 Boolean'Image(Gnose_Context.Projects_Params.With_Aws));

   end Print_Context;
   
   
   
end Gnos.Gnose;
