--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Gnostic is Ada Generic Neural Object System Engineering.                                                                                                --
-- Gnostic (C) Copyright 2016 Manuel De Girardi.                                                                                                           --
--------------------------------------------------------------------------------------------------------------------------------------------------------------
  
--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Date        := 2016-11-27 19:33:08 ; 
-- Description : Ada Generic Neural Object System Engineering.                                                                                              --
-- Version     := 2016.12.1a ; 
-- Authors     : Manuel De Girardi.                                                                                                                         --
--------------------------------------------------------------------------------------------------------------------------------------------------------------
with Ada.Calendar;
use Ada.Calendar;
package Gnos.Abstracts is
	
	type String_Access is access all String;
	type Wide_String_Access is access all Wide_String;

	type Abstract_Project_Type is tagged
		record
		   Name : string_access;
		   Description : wide_string_access;
		end record;
	
	type Abstract_Project_Access is access all Abstract_Project_Type'Class;
	
	type Abstract_Data_Type is abstract tagged
		record
			Project : Abstract_Project_Access;
		end record;
end Gnos.Abstracts;
