-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
package El is
   pragma Pure (El);
   
   Columns_Max : constant Positive := 320;
   Lines_Max   : constant Positive := 82;
   
   subtype Column_Range is Natural range 0 .. Columns_Max;
   subtype Line_Range is Positive range 1 .. Lines_Max;
   
   
   type Major_Range is new Natural range 0 .. 2399;
   type Minor_Range is new Natural range 0 .. Natural ' Last;
   type Revision_Range is new Natural range 0 .. Natural ' Last;
   type Release_Enum is ('r', 'a', 'b');
   
   
   
   type Version_Record is tagged
      record
	 Major : Major_Range := Major_Range ' First;
	 Minor : Minor_Range := Minor_Range ' First;
	 Revision : Revision_Range := Revision_Range ' First;
	 Release   : Release_Enum := Release_Enum ' First;
      end record;   
   function To_String (Version : in Version_Record) return String;
   

   
   Null_Version : constant Version_Record :=
     (Major_Range ' First, Minor_Range ' First, Revision_Range ' First, Release_Enum ' First);
   
   
   
   subtype Year_Range is Natural range Natural ' First .. Natural ' Last;   
   subtype Month_Range is Natural range Natural ' First .. Natural ' Last;
   subtype Day_Range is Natural range Natural ' First .. Natural ' Last;
   
   type Date_Record is tagged
      record
	 Year : Year_Range := Year_Range ' First;
	 Month : Month_Range := Month_Range ' First;
	 Day : Day_Range := Day_Range ' First;
	 Hours : Duration := Duration ' First;
      end record;
   
   Null_Date : constant Date_Record :=
     (Year_Range ' First, Month_Range ' First, Day_Range ' First, Duration ' First);
   
   type Hour_Range is new Natural range Natural ' First .. Natural ' Last;
   type Minute_Range is new Natural range Natural ' First .. Natural ' Last;
   type Second_Range is new Natural range Natural ' First .. Natural ' Last;
   
   type Oclock_Record is tagged
      record
	 Hour : Hour_Range := Hour_Range ' First;
	 Minute : Minute_Range := Minute_Range ' First;
	 Second : Second_Range := Second_Range ' First;
      end record;
   
   Null_Oclock : constant Oclock_Record := 
     
     (Hour_Range ' First, Minute_Range ' First, Second_Range ' First);
   
   
   type Term_Enum is (Linux, fvwm1, Uncknow, Ms);
   
   subtype Word_Size_Range is Natural range 1 .. 24; 
   -- size in natural of max word in binary.
   
   subtype Word_Range is natural range 0.. 128; 
   -- max word by line in natural. 
   
   subtype Lexical_Range is Natural range 0 .. 2**Word_Size_Range'Last; 
   -- Max word in natural.         

   subtype Layer_Width_Range is Natural range 0..Word_Size_Range'Last * Word_Range'Last; 
   -- Width of nodes for the neural network layer in natural
   
   Shell_File : constant String := ".shell_outfile.txt";
   
   type Machine_Range is new Positive range 1 .. 256;
   
   type Player_Enum is (Null_Player, Human_Player, Machine_Player);
   
   
   type Tag_Name is 
     (Null_Tag,
      Universe, Animal, Content,  Planning, Plan, Activity,  Event, Note, 
      Perso_Ac, Def_Class, Acc_Line, Deal, Entep_Ac, Contact, Car, House,
      Saved_Ac);-- Def Class is some Attributes...
   
   type Abstract_Object is tagged
      record
	 Name  : El.Tag_Name := El.Null_Tag;
	 Ucost : Float := 0.0;
	 Hcost : Float := 0.0;	       
      end record;
   
   Default_Ranking : constant array (El.Tag_Name range Universe .. Saved_ac) of Abstract_Object := 
     (--El.Null_Tag => (El.Null_Tag, 0.0, 0.0),
      
      El.Universe => (El.Universe, -100.0, 100.0),
      El.Animal => (El.Animal, -101.0, 110.0),
      El.Contact => (El.Contact, -1.0, 1.1),
      El.Event => (El.Event, -125.0, 125.0),
      El.Note => (El.Note, -0.5, 1.0),
      El.Saved_Ac => (El.Saved_ac, -105.0, 110.0),
      El.Perso_Ac => (El.Perso_Ac, -102.5, 105.0),
      El.Entep_Ac => (El.Entep_Ac, -110.0, 110.0),
      El.Acc_Line => (El.Acc_Line, -0.1, 1.0),
      El.Car => (El.Car, -100.0, 110.0),
      El.House => (El.House, -100.0, 100.0),
      El.Content => (El.Content, -12.0, 12.5),
      El.Activity => (El.Activity, -100.0, 110.0),
      El.Deal => (El.Deal, -10.0, 11.0),
      El.Planning =>(El.Planning, -1.0, 1.0),
      El.Plan => (El.Plan, -0.1, 0.5),
      El.Def_Class => (El.Def_Class, -1.0, 2.0)
     );
   
   subtype Name_Index_Type is Positive range 1..16;
   
   Name_Length : constant Name_Index_Type := 16;      
   
   subtype Name_Type is Wide_String(1..Name_Length);
   
   type Ranked_Class is new Abstract_Object with
      record	 
	 Date         : Date_Record := Null_Date;
	 Oclock       : Oclock_Record := Null_Oclock;
	 Attributs_Nb : Natural := 0;
	 Is_Deal_In   : Boolean := False;
	 Is_Deal_Out  : Boolean := False;
	 Is_Credit    : Boolean := False;
	 Is_Debit     : Boolean := False;
	 Saved_Sold   : Float := 0.0;
	 Perso_Sold   : Float := 0.0;
	 Entep_Sold   : Float := 0.0;
      end record;
	 
   type Rank_Array is array (Positive range <>) of access Ranked_Class;
	 
   Top_Classes : constant access Rank_Array := new Rank_Array ' (1..17 => new  Ranked_Class);
         
   procedure Class_Ranking_Init(Top_Classes : access Rank_Array);
   
   procedure Sort_Init (Top_Classes : access Rank_Array);
   
   function Nb_Binary_Digits(Count : in integer) return Natural;      
   
   --  En_Veritable : constant String := "we have the peace and we know the love in the reason and in the freedom with the power and with the will ! " ;
   --  En_Contraire : constant String := "we have the war and we uncknow the love out the reason and out the freedom in the loose ! " ;
   --  Fr_Veritable : constant String := "nous avons la paix et nous connaissons l ammour dans la raison et dans la liberté avec l énergie et avec la volonté ! " ;
   --  Fr_Contraire : constant String := "nous avons la guerre et nous ignorons l amour hors de raison et hord de libérté dans la défaite ! " ;
   
   
   
   
   
   Home : constant String := "HOME";
   Homepath : constant String := "HOMEPATH";
   
   
   type Elhoim_Enum is (Null_Cmd, Send, Say, Think, Read);
   
   Project_Name   : constant String := "elhoim";
   Project_Prefix : constant String := "lib";
   
   -- Erreur spécification.
   Specification_Error : exception;
   
   -- Limite implémentation.
   Implementation_limite : exception;

   
end El ; 
