-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
package body El is
   
      function To_String (Version : in Version_Record) return String is
      
      Major_Word : constant String :=
	Major_Range'Image(Version.Major)(2..Major_Range'Image(Version.Major)'Length);
      Minor_Word : constant String :=
	Minor_Range'Image(Version.Minor)(2..Minor_Range'Image(Version.Minor)'Length);
      Revision_Word : constant String :=
	Revision_Range'Image(Version.Revision)(2..Revision_Range'Image(Version.Revision)'Length);      
   begin
      
      return Major_Word & '.' & Minor_Word & '.' & Revision_Word & Character'Value(Release_Enum'Image(Version.Release));
   end To_String;
   
   
   function Nb_Binary_Digits(Count : in integer) return Natural is
      Number       : Natural  := 0;
      Digit_Number : Integer := 0;
   begin
      Number := Count;
      if Number = 0 then
	 return 1;
      end if;
      loop
	 exit when Number = 0;
	 Number := Number / 2;
	 Digit_Number := Digit_Number + 1;
      end loop;
      return Digit_Number;
   exception
      when Constraint_Error =>
	 return 0;
   end Nb_Binary_Digits;

      
   procedure Sort_Init (Top_Classes : access Rank_Array) is
      
      Sum_Left    : Float := 0.0;
      Buff : access Ranked_Class;
      Index      : Natural := 1;
   begin
      
      for Iter in 2 .. Top_Classes'Last loop
	 Buff := Top_Classes(Iter);	    
	 Index := Iter - 1;
	 Sum_Left := Buff.Hcost - Buff.Ucost;
	 while (Top_Classes(Index).Hcost - Top_Classes(Index).Ucost) > Sum_Left loop
	    Top_Classes(Index + 1) := Top_Classes(Index);
	    Index := Index - 1;
	    exit when Index = 0;
	 end loop;
	 Top_Classes(Index+1) := Buff;
      end loop;
      
   end Sort_Init;
   
   
   procedure Class_Ranking_Init(Top_Classes : access Rank_Array) is
      
      New_Object : access Ranked_Class;
      
   begin
      for Name in Tag_Name'Pos(Tag_Name'First) + 1 .. Tag_Name'Pos(Tag_Name'Last) loop
	 New_Object := new Ranked_Class;
	 Abstract_Object(New_Object.all) := Default_Ranking(Tag_Name'Val(Name));
	 Top_Classes(Name) := New_Object;
      end loop;      
   end Class_Ranking_Init;

end El ; 
