-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
with El.Result ;
with El.Strings;
with El.Enumes ;
with Windows_Console;

package El.Shells is
   use Enumes;
   use Result;
   use Strings;

   
   -- Default mode of Elhoim ;
   ---------------------------
   
   type Dialup_Record(Dialup : Dialup_Enum) is tagged
      record
	 Count_index : Natural := 0;
	 Line_Index  : Natural := 0;
	 Search_Founds : Wide_Result_Access := new File_Result_Record;
	 Search_Pattern : Wide_String_Access;
	 Match_Count    : Natural := 0;
	 Match_Index    : Natural := 0;
	 case Dialup is	    
	    when Neura =>
	       Neural_Dialup : Wide_Result_Access := new File_Result_Record;
	    when Sys =>
	       System_Dialup : Wide_Result_Access := new Spawn_Result_Record;
	    when web =>
	       Search_web    : Wide_Result_Access := new Search_Result_Record;
	    when Eng =>
	       Engine_Dialup : Wide_Result_Access := new Spawn_Result_Record;
	    when Intern =>
	       Intern_Dialup : Wide_Result_Access := new Spawn_Result_Record;
	 end case;
      end record;
   type Dialup_Access is access all Dialup_Record;
   
   type Dialup_Array is array (Dialup_Enum'Range) of Dialup_Access;   
   
   type Shells_Record is tagged
      record
	 Current_Dialup : Dialup_Enum;
	 Shells_Set : Dialup_Array;
	 Dialup : Dialup_Access;
      end record;
   
   function New_Shells (Init : Dialup_Enum) return Shells_Record;
   procedure Search_In (Shells : in out Shells_Record; 
			Dialup : in Dialup_Enum; Pattern : in Wide_String);

end El.Shells ; 
