-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
package El.Shared is
   
   pragma Shared_Passive (El.Shared);
   Version : Version_Record := (0, 7, 1, 'r');
   
   New_Action : Boolean := True;
   New_Description : Boolean := False;
   New_Version : Boolean := True;
   
   Max_Players : Machine_Range := 4;
   Player_Type : Player_Enum := Human_Player;
   
   shared_Date : Date_Record := (Year_Range ' First, 
			      Month_Range ' First, 
			      Day_Range ' First,
			      Duration ' First);
      
   Start_Date : Date_Record := (Year_Range ' First, 
			      Month_Range ' First, 
			      Day_Range ' First,
			      Duration ' First);
   

   procedure To_Update (New_Version : in Version_Record);
   
   Sh_Sample_Max  : Positive := 98;
   Sh_Line_Width  : Word_Range := 80;
   Sh_Max_Words   : Lexical_Range := 1023;
   Sh_Hiddens     : Layer_Width_Range := 80;
   Sh_Epochs_Max  : Positive := 9_800;
   Sh_Converged   : Float := 0.006;
   Sh_Reused      : Boolean := True;
   Sh_Samples_Max : Positive := 98;

   
end El.Shared ; 
