-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
with El.Strings;
package El.Parole is
   use Strings;
   type Word_Record is abstract tagged
      record
	 Lex : Wide_String_Access;
      end record;
      
   
   type Word_Access is access all Word_Record 'class;
   
   type Fr_Gram_Enum is (Null_Gram, Nom, Ver, Adj, Adv, Aux, Con, Pre, Pro, Art, Ono, Others_Word);
   
   type French_Word_Record(Genre : Fr_Gram_Enum) is new Word_Record with null record;
   
   type Ver_Record is new French_Word_Record(Ver) with null record;
   type Nom_Record is new French_Word_Record(Nom) with null record;
   type Adv_Record is new French_Word_Record(Adv) with null record;
   type Adj_Record is new French_Word_Record(Adj) with null record;
   type Aux_Record is new French_Word_Record(Aux) with null record;
   type Con_Record is new French_Word_Record(Con) with null record;
   type Pre_Record is new French_Word_Record(Pre) with null record;
   type Pro_Record is new French_Word_Record(Pro) with null record;
   type Art_Record is new French_Word_Record(Art) with null record;
   type Ono_Record is new French_Word_Record(Ono) with null record;
   
   type Word_Array is array (Positive range <>) of Word_Access;
   
   type Word_Set is array (natural range <>) of access Word_Array;

end El.Parole ; 
