-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
with Ada.Strings.Wide_Unbounded;
package El.Lexics is
   pragma Elaborate_Body (El.Lexics);
   generic
      type T_Item is private;
      type T_Key is private;
      with function Key_Of(Item : in T_Item) return T_Key;
      with function "<"(Left, Right : in T_Key) return Boolean;
      with function ">"(Left, Right : in T_Key) return Boolean;
   package Tree is
      
      
      type T_Tree is private;

      -- Ajouter un item.
      procedure Add(Item : in T_Item;
		    Tree : in out T_Tree);

      -- Chercher un item.
      function Find(Key : in T_Key;
		    Tree : in T_Tree) return T_Item;
      
      Key_Index : Natural := 0;
   private

      type T_Node;
      type Node_Access is access T_Node;
      type T_Node is
	 record
	    Item : T_Item;
	    Left, Right : Node_Access;
	 end record;

      type T_Tree is
	 record
	    Root : Node_Access;
	 end record;
   end Tree;
   
   use Ada.Strings;
   generic
      type T_Language is range <>;      
   package Glossary is
      type Glossary_Type is private;
      
      procedure Initialize(Glossary : in out Glossary_Type;
			   Filename : in String);
      function Keyword(Word : in Wide_String;
		       Glossary : in Glossary_type) return T_Language;
      function Image(Item : in T_Language;
		     Glossary : in Glossary_type) return Wide_String;
      
      
      function Key_Count(Glossary : in Glossary_Type) return T_Language;
      
      -- Ajouter un item.
      procedure Add(Word : in Wide_String;
		    Key  : in T_Language;
		    Glossary : in out Glossary_Type);
      
      
   private
      
      Glossary_Filename : access String := new String ' ("");
      
      type T_Word is
	 record
	    Item : T_Language := T_Language'First;
	    Word : Ada.Strings.Wide_Unbounded.Unbounded_Wide_String;
	 end record;
      
      function "<"(Left, Right : in T_word) return Boolean;
      function ">"(Left, Right : in T_word) return Boolean;
      function Key_Of(Word : T_Word) return T_Word;
      function inf(Left, Right : in T_word) return Boolean;
      function sup(Left, Right : in T_word) return Boolean;
      
      package Key_Tree is new Tree(T_word, T_Word, Key_Of, inf, sup);
      package Word_Tree is new Tree(T_word, T_Word, Key_Of, "<", ">");
      type Glossary_Type is
	 record
	    Key_Root : Key_Tree.T_Tree;
	    Word_Root : Word_Tree.T_Tree;
	    Key_Count : T_Language := T_Language'First;
	 end Record;
   end Glossary;
   

end El.Lexics ; 
