-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-01 20:03:01"
-- Version := "1.0.0a"
with PragmARC.Rem_Nn_Wrapper;
use PragmARC.Rem_Nn_Wrapper;
generic
   Size : Word_Size_Range;
   type Item_Type is(<>);
package El.Generic_Extended_Binary_Code is
   subtype Code_Type is Node_Set(1..Size);
   Code_Init : Code_Type := (others => 0.0);
   
   function Code_of(Item : in Item_Type) return Code_Type;
   function Item_Of(Code : in Code_Type) return Item_Type;
   
end El.Generic_Extended_Binary_Code;
