-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-01 20:03:01"
-- Version := "1.0.0a"
package body El.Generic_Extended_Binary_Code is
   


   
   function Code_of(Item : in Item_Type) return Code_Type is
      Code : Code_Type := Code_Init;
      Pos : Natural := Item_Type'Pos(Item);
   begin
      if Pos = 0 then
   	 return Code_Init;
      else
   	 for Index in reverse Code_Type'Range loop
   	    if Real(Pos rem 2) /= 1.0 then
   	       Code(index) := 0.0;
   	    else
   	       Code(index) := 1.0;
   	    end if;
   	    Pos := Pos/2;
   	 end loop;
   	 return Code;
      end if;
   end Code_of;

   function Item_Of(Code : in Code_Type) return Item_Type is
      Pos : Natural := 0;
   begin
      for I in reverse Code_Type'Range loop
   	 if Code(I) = 1.0 then
   	    Pos := Pos + 2**(Code_Type'Length-I);
   	 else
   	    null;
   	 end if;
      end loop;
      return Item_Type'Val(Pos);
   end Item_Of;
end El.Generic_Extended_Binary_Code;
