-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
with El.Interf ;
with El.Server ;
with El.Window ;
with el.Classe ;
with El.Enumes ;
generic
   Glossary_Filename : String;
   Width_Line :Word_Range;
   Max_Words : Lexical_Range;
   Samples_Max : Positive;
   Network_Filename : String;
   Lines : Line_Range;
   Cols  : Column_Range;   
   with package Classes is new el.Classe (<>);
   with package Window is new El.Window (<>);
package El.Config is
   use El.Enumes;
   type Config_Record;
   
   
   
   
   task type Config_Process (Config : access Config_Record) is
      entry Halt (End_Of_Program : out Boolean);
      entry Initialize;
      entry Receive (Wchar : in Wide_Character);
      entry Mode(Mode : out Mode_Enum);
      entry Reset;
      entry Switch;
      entry Lock;
      entry Unlock;
      entry Set_On_Esc(Is_Escape : in Boolean);      
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Full_Screen;
      entry Del;
      entry Begin_Of;
      entry End_Of;
      entry Overwrite;
      entry Screen_Print;
      entry Shutdown;
   end Config_Process;
   
   package Server is new El.Server (Glossary_Filename, Width_Line, 
				     Max_Words, Samples_Max, Network_Filename, 
				     Lines, Cols, Classes, 
				     Window);
   
   type Config_Record is new Interf.Interf_Record with
      record	 
	 The_Server    : access Server.Server_Record;
	 Config_Proc   : Config_Process (Config_Record ' access);	 
      end record;
   
   procedure Initialize (Config : in out Config_Record;
			 Int : in Interf.Interf_Record;
			 As_Server : in Boolean;
			 Max_Users : in Positive);

end El.Config ; 
