-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
with Text_Io;
with El.Params;
package body El.Config is
   use Interf;
   use Params;
   use Server;
   
   procedure Initialize (Config : in out Config_Record; 
			 Int : in Interf.Interf_Record; 
			 As_Server : in Boolean; 
			 Max_Users : in Positive) is
   
      
      Geometry_Parameter : constant Params.Parameter_Tagged_Record_Type :=
	Interf.Get_Parameter(Int, Params.Geometry);
      Lines : Line_Range := 67;
      Cols  : Column_Range := 240;
      
   begin
      if Geometry_Parameter.Is_Setted then
	 Lines := Lines_Number(Geometry_Parameter.Value.all);
	 Cols := Columns_Number(Geometry_Parameter.Value.all);     
      end if;
      Config.L := Lines;
      Config.C := Cols;      

      if As_Server then

	 Config.The_Server := new Server_Record(Max_Users);

	 Config.The_Server.Server_Proc.Initialize;
      end if;

   end Initialize;
   
   task body Config_Process is
      End_Of_This_Task : Boolean := False;
   begin
      loop
	 select

	    accept Halt (End_Of_Program : out Boolean) do
	       End_Of_This_Task := True;
	       End_Of_Program := End_Of_This_Task;
	       Server.Engine.Path_Finding.Astar_Task.Halt;
	       
	       if Config.The_Server /= null then
		  Config.The_Server.Hander_Lock.Seize;
		  Text_Io.Put_Line("Config : Going to shutdow the server");
		  Config.The_Server.Hander_Lock.Release;
		  
		  Config.The_Server.Server_Proc.Halt(End_Of_Program);
		  End_Of_This_Task := End_Of_Program;
		  
		  Config.The_Server.Hander_Lock.seize;
		  Text_Io.Put_Line("Halting config");
		  Config.The_Server.Hander_Lock.Release;
		  
	       else
		  Text_Io.Put_Line("Halting config");
	       end if;
	       
	       
	    end Halt;
	    if End_Of_This_Task then
	       exit;
	    end if;
	 or
	    accept Initialize do
	       null;
	    end Initialize;
	    exit;
	 end select;
      end loop;

      
      while not End_Of_This_Task loop
	 select

	    accept Halt (End_Of_Program : out Boolean) do
	       End_Of_This_Task := True;
	       End_Of_Program := End_Of_This_Task;
	       
	       Server.Engine.Path_Finding.Astar_Task.Halt;
	       
	       if Config.The_Server /= null then
		  
		  Config.The_Server.Hander_Lock.seize;		  
		  Text_Io.Put_Line("Config : Going to shutdow the server");
		  Config.The_Server.Hander_Lock.Release;
		  
		  Config.The_Server.Server_Proc.Halt(End_Of_Program);
		  End_Of_This_Task := End_Of_Program;		  	       
		  
		  Config.The_Server.Hander_Lock.seize;
		  Text_Io.Put_Line("Halting config");
		  Config.The_Server.Hander_Lock.Release;
		  
		  
	       else
		  Text_Io.Put_Line("Halting confitg");
	       end if;
	    end Halt;
	    if End_Of_This_Task then
	       exit;
	    end if;
	 or
	    accept Initialize do
	       null;
	    end Initialize;
	 or
	    accept Receive (Wchar : in Wide_Character);
	 or
	    accept Mode(Mode : out Mode_Enum);
	 or
	    accept Reset;
	 or
	    accept Switch;
	 or
	    accept Lock;
	 or
	    accept Unlock;
	 or
	    accept Set_On_Esc(Is_Escape : in Boolean);      
	 or
	    accept Page_Down;
	 or
	    accept Page_Up;
	 or
	    accept Up_Arrow;
	 or
	    accept Down_Arrow;
	 or
	    accept Left_Arrow;
	 or
	    accept Right_Arrow;
	 or
	    accept Full_Screen;
	 or
	    accept Del;
	 or
	    accept Begin_Of;
	 or
	    accept End_Of;
	 or
	    accept Overwrite;
	 or
	    accept Screen_Print;
	 or
	    accept Shutdown;
	 end select;
      end loop;
      
      Text_Io.Put_Line("Config halted");
      
      
   end Config_Process;
   

end El.Config ; 
