-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
with El.Result;
with El.Outils;
with El.Operat;
with El.Shared;
with El.Strings;
use El.Strings;


with Ada.Text_Io;
with Ada.Directories;
with Ada.Characters.Handling;
use Ada.Characters.Handling;
with Ada.Strings.Fixed;
use Ada.Strings;
with Ada.Calendar.Formatting;
use Ada.Calendar;
use Ada;
with Gnat.Strings;
use Gnat.Strings;
with Gnat.Os_Lib;
use Gnat;

with Gnat.Directory_Operations;
use Gnat;

package El.Compil is
   Path : constant String := Directory_Operations.Get_Current_Dir;
      
   
   Specifications_Filenames_Search  : Result.Spawn_Result_Record;
   
   
   
   Implementations_Filenames_Search : Result.Spawn_Result_Record;
   
   
   procedure Initialize;
   
   
   procedure Replace_description (Var_Name : in String; Value : in String; Node : in String);
   procedure Main_Description (Var_Name : in String; Value : in String; Node : in String);
   
   procedure Set_Start_Time(Date : in Calendar.Time := Calendar.Clock);
   function Check_Modification_To_New_Description return Boolean;
   function Check_Modification_To_New_Action return Boolean;
   
   procedure update (Filename : in String; Var_Name : in String; Value : in String);
   

   procedure To_Major;
   procedure To_Minor;
   procedure To_Revision;
   procedure To_Release;
   procedure Version_Update(Version : in out Version_Record; Errno : out Integer);   
end El.Compil ; 
