-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
with El.Strings ;
package El.Client is
   use Strings ;
   type Textual_Interface_Record is limited private;
   
   type Textual_Interface_Access is access Textual_Interface_Record;
   
   
   type Client_Record;
   task type Client_Process (Client : access Client_Record) is
   end Client_Process;   
   type Client_Record is tagged limited
      record
	 L : Line_Range := Line_Range ' First;
	 C  : Column_Range := Column_Range ' First;
	 Proc  : Client_Process (Client_Record ' access);
	 Textual_Int : Textual_Interface_Access;
     end record;
   
private
   task type Textual_Thread_Type (Machine : access Textual_Interface_Record) is
      --entry Initialize (Errno : out Integer);
      entry Receive(Text : in String);
      entry Send(Text : out String_Access);
      entry Exhauste(Text : out String_Access);
      entry Halt;
   end Textual_Thread_Type;
   
   type Textual_Interface_Record is tagged limited
      record
	 Textual_Thread : Textual_Thread_Type(Textual_Interface_Record ' access);
      end record;
   
end El.Client ; 
