-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
with Ada.Strings.Wide_Fixed;
use Ada.Strings;
with Ada.Characters.Handling;
use Ada.Characters;

package body El.Classe is
   function Equal(Left, Right : in Abstracted_Access) return Boolean is
   begin
      if Left = Right then
	 return True;
      end if;
      return False;
   end Equal;
   
   function Arity_Value(Line : in Wide_String) return Arity_Range is

      arity : Arity_Range := 3;
      Index : Natural := Wide_Fixed.Index(Line, " ");
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), " ");
   begin
      
      if Next /= 0 then
	 Arity := Arity_Range'Value(Handling.To_String(Line(Next+1..Line'last)));
      end if;      
      return Arity;
   exception
      when others =>
	 return Arity;
   end Arity_Value;

end El.Classe ; 
