-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
with ANSI_Console;
use ANSI_Console;
with Ada.Calendar.Formatting;
use Ada.Calendar.Formatting;
with Ada.Characters.Handling;
use Ada.Characters.Handling;
with Ada.Strings.Wide_Fixed;
use Ada.Strings;
package body El.Classe.Plans_class is
   function Period_Value(Line : in Wide_String) return Duration is
      Period : Duration := 0.0;
      
      Index : Natural := Wide_Fixed.Index(Line, " "); 
      
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), " "); 
      
      Last  : Natural := Wide_Fixed.Index(Line(Next+1..Line'Last), " ");      
      
      Back_Last : Natural := Wide_Fixed.Index(Line(Last..Line'Last), """", backward);
      Back_next : Natural := Wide_Fixed.Index(Line(last..Back_Last-1), """");
      
   begin
      if Back_next /= 0 then
	 Period := Duration'value(To_String(Line(last+20..Back_next-1)));
      end if;      
      return period;
   exception
      when others =>
	 return period;
   end Period_Value;
   
   
   function Plan_description_Value(Line : in Wide_String) return Wstring_64 is
      Desc : Wstring_64 := (others => Wide_Character'Val(32));
      
      Index : Natural := Wide_Fixed.Index(Line, " "); 
      
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), " "); 
      
      Last  : Natural := Wide_Fixed.Index(Line(Next+1..Line'Last), " ");      
      
      Back_Last : Natural := Wide_Fixed.Index(Line(Last..Line'Last), """", backward);
      Back_next : Natural := Wide_Fixed.Index(Line(last..Back_Last-1), """");
      
   begin
      if Back_Next /= 0 then
	 Wide_Fixed.Move(Line(Back_Next+1..Back_Last-1), desc);
      end if;      
      return Desc;
   exception
      when others =>
	 return Desc;
   end Plan_description_Value;
   
   
   
   
   function Object_Name(Line : in Wide_String) return Name_Type is
      Name : Name_type := (others => Wide_Character'Val(32));
      
      Index : Natural := Wide_Fixed.Index(Line, " "); 
            
   begin
      if Line'Last /= 0 then
	 Wide_Fixed.Move(Line(Index+1..Line'last), Name);
      end if;      
      return Name;
   exception
      when others =>
	 return Name;
   end Object_Name;
   
   -----------------------------------------------------------------------------
   --                        Plan
   
   
   
   function Create(Win       : in Window_Type;
		   Win_Index : in out Positive;
		   Name      : in Name_Type;
		   Date      : in Time;		   
		   Period    : in Duration;		   
		   Description : in Wstring_64
		  ) return Abstracted_Access is   
      O : Abstracted_Access;
      Label : Name_Type;
   begin
	 O := new Plan_Class;
	 if O /= null then
	 
	    Wide_Fixed.Move(Name, O.Name, Error, Left, ' ');
	    Plan_Class(O.all).Plan_Date := Date;
	    Plan_Class(O.all).Period := Period;
	    Plan_Class(O.all).end_Date := Date + Period;
	    Wide_fixed.Move(Description, Plan_Class(O.all).Description);
	    Plan_Class(O.all).Print(Win, Win_Index, Label);
	 return O;
      else
	 return null;
      end if;
   end Create;
   
   procedure Print (Object    : in Plan_Class'Class;
		    Win       : in Window_Type;
		    Win_Index : in out Positive;
		    Name      : out Name_Type) is
   begin
      Draw(Win, Win_Index+1, 3, Cyan, "Index     : " &
	     To_Wide_String(Abstracted_Index'Image(Object.Index)));
      Draw(Win, Win_Index+2, 3, Cyan, "Created   : "
	     & To_Wide_String(Image(Object.Create_Date)));            
      Draw(Win, Win_Index+3, 3, Cyan, "Name      : " & Object.Name);
      Draw(Win, Win_Index+4, 3, Cyan, "Plan Date : "	     
	     & To_Wide_String(Image(Object.Plan_Date)));
      Draw(Win, Win_Index+5, 3, Cyan, "Period    : "	     
	     & To_Wide_String(Image(Object.period)));
      Draw(Win, Win_Index+6, 3, Cyan, "End Date  : "
	     & To_Wide_String(Image(Object.End_Date)));
      Draw(Win, Win_Index+7, 3, Cyan, "Descript  : "
	     & Object.Description(1..24));
      Draw(Win, Win_Index+8, 3, Cyan, 
	   Object.Description(25..64));
      
      Win_Index := Win_Index + 9;
      
      Draw(Win, Win_Index+1, 3, Cyan, "Definition " & Object.Name);
      Win_Index := Win_Index + 1;
      for I in 1..Object.Def.Index loop
	 Draw(Win, Win_Index+1, 3, Cyan, "Attr " & To_Wide_String(Natural'Image(I)) & " : " &
		To_Wide_String(Object.Def.List(I).Names) & '=' & To_Wide_String(Object.Def.List(I).Image));
	 Win_Index := Win_Index + 1;
      end loop;
      
      
      Name := Object.Name;
   end Print;
   
   procedure Help(Plan     : in out Plan_Class'Class;
		  Win       : in Window_Type;
		  Win_Index : in out Positive;
		  Name      : out Name_Type) is
   begin
      Draw(Win, Win_Index+1, 3, Red, "create Plan : help");
      Draw(Win, Win_Index+2, 3, Cyan, "NAME is string.");
      Draw(Win, Win_Index+3, 3, Cyan, "Date is date format :");
      Draw(Win, Win_Index+4, 3, Cyan, "Ex: 2020-02-03 00:00:00");
      Draw(Win, Win_Index+5, 3, Cyan, "Duration max is in second : ");
      Draw(Win, Win_Index+6, 3, Cyan, "    9223372036.854775807");
      Draw(Win, Win_Index+7, 3, Cyan, "create Plan NAME Date Duration ""Description""");
      Win_Index := Win_Index + 5;
      Wide_Fixed.Move("help", Name, Error, Left, ' ');
   end Help;
   
   procedure Write (O : in Plan_Class;File : in W_Io.File_Type) is
      
   begin
      W_Io.Put_Line(File, To_Wide_String(Tag_Name'Image(Abstracted_Class(O).Tag)));
      W_Io.Put_Line(File, To_Wide_String(Abstracted_Index'Image(O.Index)));
      W_Io.Put_Line(File, To_Wide_String(Image(O.Create_Date)));      
      W_Io.Put_Line(File, O.Name);
      W_Io.Put_Line(File, To_Wide_String(Image(O.Plan_Date)));
      W_Io.Put_Line(File, To_Wide_String(Duration'Image(O.Period)));
      W_Io.Put_Line(File, O.Description);
      
      W_Io.Put_Line(File, To_Wide_String(Natural'Image(O.Def.Index)));
      for I in 1..O.Def.Index loop
	 W_Io.Put_Line(File, To_Wide_String(O.Def.List(I).Names) & '=' & To_Wide_String(O.Def.List(I).Image));
      end loop;
      
   end Write;
   
   procedure Read (O : in out Plan_Class;File : in W_Io.File_Type) is
      Name_Last : Natural := 0;
      Date_Last : Natural := 0;
      
      Empty : Wide_String(1..80);
      Empty_Last : Natural := 0;     
      
      Att_Index : Natural := 0;
   begin
      --Put("TOTO 1");
      O.Index := Integer'Value(To_String(W_Io.Get_Line(File)));
      --Put("TOTO 2");
      O.Create_Date := Value(To_String(W_Io.Get_Line(File)));
      --Put("TOTO 3");
      W_Io.Get_Line(File, O.Name, Name_last);            
      --Put("TOTO 4");
      W_Io.Get_Line(File, Empty, Empty_Last); 
      -- obscure blank line      
      
      W_Io.Get_Line(File, empty, Date_Last);
      O.Plan_Date := Formatting.Value(To_String(Empty(1..19)));
      
      O.Period := Duration'Value(To_String(W_Io.Get_Line(File)));
      O.End_Date := O.Plan_Date + O.Period;
      W_Io.Get_Line(File, empty, Empty_Last);      
      Wide_Fixed.Move(Empty(1..Empty_Last), O.Description);
      
      
      Att_Index := Natural'Value(To_String(W_Io.Get_Line(File)));
      for I in 1..Att_Index loop
	 declare
	    Tags      : String_Access;
	    Image     : String_Access;
	 begin
	    Parse(W_Io.Get_Line(File), Tags, Image);
	    O.Def.List(I) := Make (Tags.all, Image.all);
	    O.Def.Index := O.Def.Index + 1;
	 end;
      end loop;

      
   end Read;
   
   procedure Random (O : in out Plan_Class) is
   begin
      null;
   end Random;
   --
   -----------------------------------------------------------------------------

end El.Classe.Plans_class ; 
