-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
with El.Strings;
generic
package El.Classe.Houses_class is
   use Strings;
   --------------------------------------------------------------------------
   --                        HOUSE
   
   
   subtype Address_Type is Wide_String (1..24);
   
   function surface_Value(Line : in Wide_String) return Name_Type;
   function address_Value(Line : in Wide_String) return Address_Type;
   function City_name_Value(Line : in Wide_String) return Address_Type;
   function City_code_Value(Line : in Wide_String) return Name_Type;
   
   
   type House_Class is new Abstracted_Class(House) with
      record	 
	 Surface  : Name_Type := (others => ' ');
	 Address  : address_Type := (others => ' ');
	 Code     : Name_Type := (others => ' ');
	 City     : Address_Type := (others => ' ');
      end record;
   
   procedure Print (Object    : in House_Class'class;
		    Win       : in Window_Type;
		    Win_Index : in out Positive;
		    Name      : out Name_Type);
   
   procedure Help(House     : in out House_Class'class;
		  Win       : in Window_Type;
		  Win_Index : in out Positive;
		  Name      : out Name_Type);
   
   function Create(Win       : in Window_Type;
		   Win_Index : in out Positive;		   
		   Name      : in Name_Type;
		   Surface   : in Name_Type;
		   Address   : in address_Type;
		   Code      : in Name_Type;
		   City      : in Address_Type) return Abstracted_Access;
   
   procedure Write (O : in House_Class; File : in W_Io.File_Type);
   procedure Read (O : in out House_Class; File : in W_Io.File_Type);
   procedure Random (O : in out House_Class);
   --                  End NHOUSE 
   --------------------------------------------------------------------------


end El.Classe.Houses_class ; 
