-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
with ANSI_Console;
use ANSI_Console;
with Ada.Calendar.Formatting;
use Ada.Calendar.Formatting;
with Ada.Characters.Handling;
use Ada.Characters.Handling;
with Ada.Strings.Wide_Fixed;
use Ada.Strings;
package body El.Classe.Houses_class is
   
   function City_name_Value(Line : in Wide_String) return Address_Type is
      city : Address_type := (others => Wide_Character'Val(32));
      
      Last_2  : Natural := Wide_Fixed.Index(Line(Line'first..Line'Last-1), """", backward); 
      
      Last  : Natural := Wide_Fixed.Index(Line(Line'first..Last_2-1), " ", backward); 
      
   begin
      if Last_2 /= 0 then
	 Wide_Fixed.Move(Line(Last+2 .. Line'Last-1), city);
      end if;      
      return city;
   exception
      when others =>
	 return city;
   end City_name_Value;
   
   function City_code_Value(Line : in Wide_String) return Name_type is
      code : Name_type := (others => Wide_Character'Val(32));
      
      Last_2  : Natural := Wide_Fixed.Index(Line(Line'first..Line'Last-1), """", backward); 
      
      Last  : Natural := Wide_Fixed.Index(Line(Line'first..Last_2-2), " ", backward); 
      
      --prev  : Natural := Wide_Fixed.Index(Line(Line'first..Last-1), " ", backward); 
      
   begin
      if Last_2 /= 0 then
	 Wide_Fixed.Move(Line(Last+1 .. Last_2-2), code);
      end if;      
      return code;
   exception
      when others =>
	 return code;
   end City_code_Value;
   
   
   function surface_Value(Line : in Wide_String) return Name_Type is
      
      surface : Name_type := (others => Wide_Character'Val(32));
      Index : Natural := Wide_Fixed.Index(Line, " "); 
      
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), " "); 
      
      Last  : Natural := Wide_Fixed.Index(Line(Next+1..Line'Last), " ");
      
      Last_2  : Natural := Wide_Fixed.Index(Line(Last+1..Line'Last), " ");
   begin
      if Next /= 0 then
	 Wide_Fixed.Move(Line(Last+1..Last_2-1), surface);
      end if;      
      return surface;
   exception
      when others =>
	 return surface;
   end Surface_Value;
   
   
   
   function address_Value(Line : in Wide_String) return Address_Type is
      Address : Address_type := (others => Wide_Character'Val(32));
      
      
      Index : Natural := Wide_Fixed.Index(Line(Line'First..Line'Last-1), """", backward); 
      
      Next  : Natural := Wide_Fixed.Index(Line(Line'first..Index-1), """", backward); 
      
      Last  : Natural := Wide_Fixed.Index(Line(Line'first..Next-1), """", backward);
            
   begin
      if Next /= 0 then
	 Wide_Fixed.Move(Line(Last+1..next-1), address);
      end if;      
      return address;
   exception
      when others =>
	 return address;
   end address_Value;
   
   --------------------------------------------------------------------------
   --                        NOTE
      
   procedure Print (Object    : in House_Class'class;
		    Win       : in Window_Type;
		    Win_Index : in out Positive;
		    Name      : out Name_Type) is
   begin
      Wide_Fixed.Move(Object.Name, Name, Error, Left, ' ');
      Draw(Win, Win_Index+1, 3, Cyan, "Index   : " &
	     To_Wide_String(Abstracted_Index'Image(Object.Index)));
      Draw(Win, Win_Index+2, 3, Cyan, "Created : " &
	     To_Wide_String(Image(Object.Create_Date)));
      Draw(Win, Win_Index+3, 3, Cyan, "Name    : " & Object.Name);
      Draw(Win, Win_Index+4, 3, Cyan, "Surface : ");
      Draw(Win, Win_Index+4, 14, Cyan, 
	   Object.Surface(1..Wide_Fixed.Index_Non_blank(Object.surface, Backward)));
      Draw(Win, Win_Index+5, 3, Cyan, "Address : " &
	     Object.Address(1..Wide_Fixed.Index_Non_blank(Object.Address, Backward)));
      Draw(Win, Win_Index+6, 3, Cyan, "Code : " &
	     Object.Code(1..Wide_Fixed.Index_Non_blank(Object.code, Backward)));
      Draw(Win, Win_Index+7, 3, Cyan, "City : " & Object.City(1..Wide_Fixed.Index_Non_blank(Object.City, Backward)));
      Win_Index := Win_Index + 8;
      Draw(Win, Win_Index+1, 3, Cyan, "Definition " & Object.Name);
      Win_Index := Win_Index + 1;
      for I in 1..Object.Def.Index loop
	 Draw(Win, Win_Index+1, 3, Cyan, "Attr " & To_Wide_String(Natural'Image(I)) & " : " &
		To_Wide_String(Object.Def.List(I).Names) & '=' & To_Wide_String(Object.Def.List(I).Image));
	 Win_Index := Win_Index + 1;
      end loop;
      
   end Print;
   
   procedure Help(House   : in out House_Class'class;
		  Win       : in Window_Type;
		  Win_Index : in out Positive;
		  Name      : out Name_Type) is
   begin
      Draw(Win, Win_Index+1, 3, Red, "create note : help");
      Draw(Win, Win_Index+2, 3, Cyan, "create HOUSE Name surface ""Address"" code ""city""");
      Win_Index := Win_Index + 2;
      Wide_Fixed.Move("help", Name, Error, Left, ' ');      
   end Help;
   
   
   function Create(Win       : in Window_Type;
		   Win_Index : in out Positive;		   
		   Name      : in Name_Type;
		   Surface   : in Name_Type;
		   Address   : in address_Type;
		   Code      : in Name_Type;
		   City      : in Address_Type) return Abstracted_Access is

      
      Label : Name_Type := (others => ' ');
      
      O : Abstracted_Access := new House_Class;
   begin
      if O /= null then	 
	 Wide_Fixed.Move(Name, O.Name, Error, Left, ' ');
	 House_Class(O.all).Surface := Surface;
	 House_Class(O.all).Address := Address;
	 House_Class(O.all).Code := Code;
	 House_Class(O.all).City := City;
	 House_Class(O.all).Print(Win, Win_Index, Label);
	 return O;
      else
	 return null;
      end if;
   end Create;
   
   procedure Write (O : in House_Class; File : in W_Io.File_Type) is
   begin
      W_Io.Put_Line(File, To_Wide_String(Tag_Name'Image(Abstracted_Class(O).Tag)));
      W_Io.Put_Line(File, To_Wide_String(Abstracted_Index'Image(O.Index)));
      W_Io.Put_Line(File, To_Wide_String(Image(O.Create_Date)));
      W_Io.Put_Line(File, O.Name);
      W_Io.Put_Line(File, O.surface);
      W_Io.Put_Line(File, O.address);
      W_Io.Put_Line(File, O.code);
      W_Io.Put_Line(File, O.city);
      
      W_Io.Put_Line(File, To_Wide_String(Natural'Image(O.Def.Index)));
      for I in 1..O.Def.Index loop
	 W_Io.Put_Line(File, To_Wide_String(O.Def.List(I).Names) & '=' & To_Wide_String(O.Def.List(I).Image));
      end loop;
      
   end Write;
   procedure Read (O : in out House_Class; File : in W_Io.File_Type) is
      Name_Last : Natural := 0;
      House_Last : Natural := 0;
      Empty : Wide_String(1..80);
      Empty_Last : Natural := 0;
      
      Att_Index : Natural := 0;
   begin           

      O.Index := Integer'Value(To_String(W_Io.Get_Line(File)));

      O.Create_Date := Value(To_String(W_Io.Get_Line(File)));
      
      W_Io.Get_Line(File, O.Name, Name_last);
      declare
	 Empty_1 : Wide_String := W_Io.Get_Line(File);
      begin
	 null;
      end;      
      -- obscure blank line      

      
      W_Io.Get_Line(File, Wide_String(O.surface), House_Last);
      
      declare
	 Empty_1 : Wide_String := W_Io.Get_Line(File);
      begin
	 null;
      end;
      -- obscure blank line      

      
      
      
      W_Io.Get_Line(File, Wide_String(O.address), House_Last);
      
      declare
	 Empty_1 : Wide_String := W_Io.Get_Line(File);
      begin
	 null;
      end;    
      -- obscure blank line      

      
      
      W_Io.Get_Line(File, Wide_String(O.code), House_Last);
      
      declare
	 Empty_1 : Wide_String := W_Io.Get_Line(File);
      begin
	 null;
      end;            
      -- obscure blank line      

      
      
      W_Io.Get_Line(File, Wide_String(O.city), House_Last);
      declare
	 Empty_1 : Wide_String := W_Io.Get_Line(File);
      begin
	 null;
      end;
      -- obscure blank line      
      Att_Index := Natural'Value(To_String(W_Io.Get_Line(File)));
      for I in 1..Att_Index loop
	 declare
	    Tags      : String_Access;
	    Image     : String_Access;
	 begin
	    Parse(W_Io.Get_Line(File), Tags, Image);
	    O.Def.List(I) := Make (Tags.all, Image.all);
	    O.Def.Index := O.Def.Index + 1;
	 end;
      end loop;
      
   end Read;
   
   
   procedure Random (O : in out House_Class) is
   begin
      null;
   end Random;
   --------------------------------------------------------------------------

end El.Classe.Houses_class ; 
