-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
with ANSI_Console;
use ANSI_Console;
with Ada.Calendar.Formatting;
use Ada.Calendar.Formatting;
with Ada.Characters.Handling;
use Ada.Characters.Handling;
with Ada.Strings.Wide_Fixed;
use Ada.Strings;
package body El.Classe.Events_class is
   package W_Io renames Ada.Wide_Text_Io;
   
   function Date_Value(Line : in Wide_String) return Date_Wstring is
      
      Date  : Date_Wstring := (others => Wide_Character'Val(32));
      Index : Natural := Wide_Fixed.Index(Line, " ");
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), " ");      
      Last  : Natural := Wide_Fixed.Index(Line(Next+1..Line'Last), " ");      
   begin
      
      if Last /= 0 then
	 Wide_Fixed.Move(Line(last+1..Line'last), Date);
      end if;      
      return Date;
   exception
      when others =>
	 return Date;
   end Date_Value;
   
   
   function Event_Value(Line : in Wide_String) return Name_Type is
      Name : Name_type := (others => Wide_Character'Val(32));
      
      Index : Natural := Wide_Fixed.Index(Line, " "); 
      
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), " "); 
      
      Last  : Natural := Wide_Fixed.Index(Line(Next+1..Line'Last), " ");      
   begin
      if Last /= 0 then
	 Wide_Fixed.Move(Line(next+1..Last-1), Name);
      end if;      
      return Name;
   exception
      when others =>
	 return Name;
   end Event_Value;
   
   -----------------------------------------------------------------------------
   --                        Event
   function Create(Win       : in Window_Type;
		   Win_Index : in out Positive;
		      Date      : in Time;
		      Name      : in Name_Type) return Abstracted_Access is
      O : Abstracted_Access;
   begin
	 O := new Event_Class;
	 if O /= null then
	 
	    Wide_Fixed.Move(Name, O.Name, Error, Left, ' ');
	    
	    Wide_Fixed.Move(To_Wide_String(Image(Date)), 
			    Event_Class(O.all).Event_Date, Error, Left, ' ');
	    
	    Draw(Win, Win_Index+1, 3, Cyan, "Created : " &
		   To_Wide_String(Image(Event_Class(O.all).Create_Date)));
	    Draw(Win, Win_Index+2, 3, Cyan, "Name    : " &
		   Event_Class(O.all).Name);
	    Draw(Win, Win_Index+3, 3, Cyan, "Date of : " & 
		   Event_Class(O.all).Event_Date);
	    
	 return O;
      else
	 return null;
      end if;
   end Create;
   
   procedure Print (Object    : in Event_Class'Class;
		    Win       : in Window_Type;
		    Win_Index : in out Positive;
		    Name      : out Name_Type) is
   begin
      Draw(Win, Win_Index+1, 3, Cyan, "Index   : " &
	     To_Wide_String(Abstracted_Index'Image(Object.Index)));
      Draw(Win, Win_Index+2, 3, Cyan, "Created : "
	     & To_Wide_String(Image(Object.Create_Date)));            
      Draw(Win, Win_Index+3, 3, Cyan, "Name    : " & Object.Name);
      Draw(Win, Win_Index+4, 3, Cyan, "Date of : "
	     & Object.Event_Date);
      Win_Index := Win_Index + 4;
      
      Draw(Win, Win_Index+1, 3, Cyan, "Definition " & Object.Name);
      Win_Index := Win_Index + 1;
      for I in 1..Object.Def.Index loop
	 Draw(Win, Win_Index+1, 3, Cyan, "Attr " & To_Wide_String(Natural'Image(I)) & " : " &
		To_Wide_String(Object.Def.List(I).Names) & '=' & To_Wide_String(Object.Def.List(I).Image));
	 Win_Index := Win_Index + 1;
      end loop;
      
      
      Name := Object.Name;
   end Print;
   
   procedure Help(Event     : in out Event_Class'Class;
		  Win       : in Window_Type;
		  Win_Index : in out Positive;
		  Name      : out Name_Type) is
   begin
      Draw(Win, Win_Index+1, 3, Red, "create event : help");
      Draw(Win, Win_Index+2, 3, Cyan, "NAME is string.");
      Draw(Win, Win_Index+3, 3, Cyan, "Date is date format :");
      Draw(Win, Win_Index+4, 3, Cyan, "Ex: 2020-02-03 00:00:00");
      Draw(Win, Win_Index+5, 3, Cyan, "create event NAME Date");
      Win_Index := Win_Index + 5;
      Wide_Fixed.Move("help", Name, Error, Left, ' ');
   end Help;
   
   procedure Write (O : in Event_Class;File : in W_Io.File_Type) is
      
   begin
      W_Io.Put_Line(File, To_Wide_String(Tag_Name'Image(Abstracted_Class(O).Tag)));
      W_Io.Put_Line(File, To_Wide_String(Abstracted_Index'Image(O.Index)));
      W_Io.Put_Line(File, To_Wide_String(Image(O.Create_Date)));
      W_Io.Put_Line(File, O.Name);
      W_Io.Put_Line(File, O.Event_Date);
      
      W_Io.Put_Line(File, To_Wide_String(Natural'Image(O.Def.Index)));
      for I in 1..O.Def.Index loop
	 W_Io.Put_Line(File, To_Wide_String(O.Def.List(I).Names) & '=' & To_Wide_String(O.Def.List(I).Image));
      end loop;
      
   end Write;
   
   procedure Read (O : in out Event_Class;File : in W_Io.File_Type) is
      Name_Last : Natural := 0;
      Date_Last : Natural := 0;
      
      Empty : Wide_String(1..80);
      Empty_Last : Natural := 0;     
      
      Att_Index : Natural := 0;
   begin

      O.Index := Integer'Value(To_String(W_Io.Get_Line(File)));

      O.Create_Date := Value(To_String(W_Io.Get_Line(File)));

      W_Io.Get_Line(File, O.Name, Name_last);            

      declare
	 Empty_1 : Wide_String := W_Io.Get_Line(File);
      begin
	 null;
      end;
       
      -- obscure blank line      
      
      W_Io.Get_Line(File, O.Event_Date, Date_Last);
      declare
	 Empty_1 : Wide_String := W_Io.Get_Line(File);
      begin
	 null;
      end;
      
      Att_Index := Natural'Value(To_String(W_Io.Get_Line(File)));
      for I in 1..Att_Index loop
	 declare
	    Tags      : String_Access;
	    Image     : String_Access;
	 begin
	    Parse(W_Io.Get_Line(File), Tags, Image);
	    O.Def.List(I) := Make (Tags.all, Image.all);
	    O.Def.Index := O.Def.Index + 1;
	 end;
      end loop;

   end Read;
   
   procedure Random (O : in out Event_Class) is
   begin
      null;
   end Random;
   --
   -----------------------------------------------------------------------------

end El.Classe.Events_class ; 
