-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
generic
package El.Classe.Define is
   type Define_Class is new Abstracted_Class(Def_Class) with
      record
	 Definition : Attributs(7);
      end record;
   
   function Create(Win       : in Window_Type;
		   Win_Index : in out Positive;
		   Date      : in Time;		   
		   Name      : in Name_Type;
		   Def       : in Wide_String) return Abstracted_Access;
   
   procedure Print (Object    : in Define_Class'Class;
		    Win       : in Window_Type;
		    Win_Index : in out Positive;
		    Name      : out Name_Type);
   
   procedure Help(Def       : in out Define_Class'Class;
		  Win       : in Window_Type;
		  Win_Index : in out Positive;
		  Name      : out Name_Type);
   
   procedure Write (O : in Define_Class;File : in W_Io.File_Type);
   procedure Read (O : in out Define_Class;File : in W_Io.File_Type);
   
   procedure Random (O : in out Define_Class);

end El.Classe.Define ; 
