-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
with El.Classe.Accoun;
with El.Strings;
generic

   with package Account is new El.Classe.Accoun (<>);

package El.Classe.Deallines_class is
   use Account;
   use Strings;
   --------------------------------------------------------------------------
   --                    Dealline                                       --
   function denom_Value(Line : in Wide_String) return Wstring_16;
   function Acc_name_Value(Line : in Wide_String) return Name_Type;
   function Peer_name(Line : in Wide_String) return Wstring_32;
   function Account_num_value(Line : in Wide_String) return Account_Num_Range;
   function quantity_value(Line : in Wide_String) return Quantity_Range;
   function Payment_Delays_Value(Line : in Wide_String) return Payment_Delay;
   function U_Ht_value(Line : in Wide_String) return Fixed_Unit_Ht;
   function TVA_value(Line : in Wide_String) return Fixed_Factor;
   
   type Deal_Class is new Abstracted_Class(Deal) with
      record
	 Line : Account_Line_Type;
	 State : Account_State_Type;
      end record;
   
   
   
   function Create(Win       : in Window_Type;
		   Win_Index : in out Positive;
		   Name      : in Name_Type;
		   description   : in Wstring_16;
		   Account_num   : in Account_Num_Range;
		   Unit_Ht_Price : in Fixed_Unit_Ht;	 
		   TVA_Factor    : in Fixed_Factor;
		   Quantity      : in Quantity_Range;
		   Delays        : in Payment_Delay;
		   Peer_name     : in Wstring_32) return Abstracted_Access;
   
   procedure Print (Object    : in Deal_Class'Class;
		    Win       : in Window_Type;
		    Win_Index : in out Positive;
		    Name      : out Name_Type);
   
   procedure Help(Dealline    : in out Deal_Class'Class;
		  Win       : in Window_Type;
		  Win_Index : in out Positive;
		  Name      : out Name_Type);
   
   
   procedure Account_Line_draw(Wins : in Accounting_Windows_Type'Class;
			       Index_Line : in Index_Line_Range;
			       Account_Line : in Account_Line_Type);
   
   
   
   
   
   
   procedure Write (O : in Deal_Class;File : in W_Io.File_Type);
   procedure Read (O : in out Deal_Class;File : in W_Io.File_Type);
   procedure Random (O : in out Deal_Class);
   
   --                 End Dealline                                         --
   --------------------------------------------------------------------------

end El.Classe.Deallines_class ; 
