-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   <one line to give the program's name and a brief idea of what it does.>
--   Copyright (C) 19yy  <name of author>
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
with El.Strings;
generic
package El.Classe.Activities_class is
   use Strings;
--------------------------------------------------------------------------
   --                    ACTIVITY                                       --
   -- ("raison_sociale", "address", type, regime, affiliation).
   
   function Affilia_Value(Line : in Wide_String) return Wstring_24;
   function Fiscal_Value(Line : in Wide_String) return Wstring_24;
   function Ste_Type_Value(Line : in Wide_String) return Wstring_24;
   function Full_address_Value(Line : in Wide_String) return Wstring_38;
   function Raison_Value(Line : in Wide_String) return Wstring_38;
   
   
   
   
   type Activity_Class is new Abstracted_Class(Activity) with
      record
	 Raison   : Wstring_38 := (others => ' ');
	 Address  : Wstring_38 := (others => ' ');
	 Ste_Type : Wstring_24 := (others => ' ');
	 Fiscal   : Wstring_24 := (others => ' ');
	 Affilia  : Wstring_24 := (others => ' ');
      end record;
  function Create(Win       : in Window_Type;
		   Win_Index : in out Positive;
		   Name      : in Name_Type;
		   Raison    : in Wide_String;
		   Address   : in Wide_String;
		   Ste_Type  : in Wide_String;
		   Affilia   : in Wide_String;
		   Fiscal    : in Wide_String) return Abstracted_Access;
   
   procedure Print (Object    : in Activity_Class'Class;
		    Win       : in Window_Type;
		    Win_Index : in out Positive;
		    Name      : out Name_Type);
   
   procedure Help(Activity    : in out Activity_Class'Class;
		  Win       : in Window_Type;
		  Win_Index : in out Positive;
		  Name      : out Name_Type);
   
   procedure Write (O : in Activity_Class;File : in W_Io.File_Type);
   procedure Read (O : in out Activity_Class;File : in W_Io.File_Type);
   procedure Random (O : in out Activity_Class);

end El.Classe.Activities_class ; 
